/*
 * Decompiled with CFR 0.152.
 */
package jsesh.docdisplayer;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DocDisplayer
extends JFrame {
    private static DocDisplayer instance;
    private JTextPane docPanel = new JTextPane();

    private DocDisplayer() {
        super("JSesh Documentation");
        this.getContentPane().add(new JScrollPane(this.docPanel));
        this.setSize(640, 600);
        URL base = this.getClass().getResource("/jseshResources/userdoc/index.html");
        try {
            this.docPanel.setPage(base);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Problem while loading the documentation\n" + e.getMessage() + "(url : " + base + ")");
            e.printStackTrace();
        }
        this.docPanel.setEditable(false);
        this.docPanel.addHyperlinkListener(new Control());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                instance = null;
            }

            public void windowClosed(WindowEvent e) {
                DocDisplayer.this.dispose();
                instance = null;
            }
        });
    }

    public static DocDisplayer getInstance() {
        if (instance == null) {
            instance = new DocDisplayer();
        }
        return instance;
    }

    public static void main(String[] args) {
        DocDisplayer.getInstance().setVisible(true);
    }

    private class Control
    implements HyperlinkListener {
        private Control() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    DocDisplayer.this.docPanel.setPage(e.getURL());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

