/*
 * Decompiled with CFR 0.152.
 */
package jsesh.easyweb;

import java.io.StringReader;
import java.util.LinkedList;
import jsesh.easyweb.Signe;
import jsesh.mdc.MDCParserFacade;
import jsesh.mdc.interfaces.CadratInterface;
import jsesh.mdc.interfaces.HieroglyphInterface;
import jsesh.mdc.interfaces.MDCBuilderAdapter;
import jsesh.mdc.interfaces.ModifierInterface;
import jsesh.mdc.interfaces.ModifierListInterface;
import jsesh.mdc.interfaces.OptionListInterface;

public class Analyseur {
    private MDCParserFacade parser;
    private SignListBuilder builder = new SignListBuilder();

    public Analyseur() {
        this.parser = new MDCParserFacade(this.builder);
    }

    public Signe[] analyser(String texte) throws Exception {
        this.parser.parse(new StringReader(texte));
        return this.builder.result.toArray(new Signe[this.builder.result.size()]);
    }

    public static void main(String[] args) throws Exception {
        Analyseur analyseur = new Analyseur();
        Signe[] s = analyseur.analyser("p\\r*t\\:pt\\d:n-<-ra-mn:n-xpr->-sw-t:n-G7\\d");
        for (int i = 0; i < s.length; ++i) {
            System.out.print(s[i].toString() + " ");
        }
        System.out.println();
    }

    private class SignListBuilder
    extends MDCBuilderAdapter {
        public LinkedList result;

        private SignListBuilder() {
        }

        public void reset() {
            this.result = new LinkedList();
        }

        public ModifierListInterface buildModifierList() {
            return new SimpleModifier();
        }

        public void addModifierToModifierList(ModifierListInterface mods, String name, Integer value) {
            SimpleModifier m = (SimpleModifier)mods;
            if ("d".equals(name)) {
                m.isDeterminative = true;
            }
        }

        public HieroglyphInterface buildHieroglyph(boolean isGrammar, int type, String code, ModifierListInterface m, int isEnd) {
            Signe s = new Signe(code);
            if (((SimpleModifier)m).isDeterminative) {
                s.setDeterminative(true);
            }
            this.result.add(s);
            return null;
        }

        public void setOptionList(CadratInterface result, OptionListInterface e1) {
        }
    }

    private class SimpleModifier
    implements ModifierListInterface,
    ModifierInterface {
        public boolean isDeterminative = false;

        private SimpleModifier() {
        }
    }
}

