/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.control;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jsesh.externalFonts.model.ExternalSignImporterModel;
import jsesh.externalFonts.ui.ExternalSignImporterUI;
import jsesh.externalFonts.ui.UIEventListener;
import jsesh.hieroglyphs.HieroglyphsManager;

public class ExternalSignImporterPresenter
implements UIEventListener {
    ExternalSignImporterModel model;
    ExternalSignImporterUI ui;

    public ExternalSignImporterPresenter(ExternalSignImporterModel model, ExternalSignImporterUI ui) {
        this.model = model;
        this.ui = ui;
        this.refreshUI();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        this.doAction(src);
    }

    private void doAction(Object src) {
        boolean signChanged = false;
        if (src != this.ui.getCloseButton() && src != this.ui.getCodeField()) {
            if (src == this.ui.getImportButton()) {
                this.importSigns();
                signChanged = true;
            } else if (src == this.ui.getInsertButton()) {
                this.model.insertSign(this.ui.getCodeField().getText());
            } else if (src == this.ui.getNextButton()) {
                signChanged = true;
                this.model.nextSign();
            } else if (src == this.ui.getPreviousButton()) {
                signChanged = true;
                this.model.previousSign();
            } else if (src == this.ui.getFlipHorizontallyButton()) {
                this.model.flipHorizontally();
            } else if (src == this.ui.getFlipVerticallyButton()) {
                this.model.flipVertically();
            } else if (src == this.ui.getFullCadratHeightButton()) {
                this.model.resizeVerticallyTo(this.model.getReferenceShape().getBbox().getHeight());
            }
        }
        if (signChanged) {
            this.ui.getCodeField().setText(this.model.getDefaultSignCode());
        }
        this.refreshUI();
    }

    private void importSigns() {
        JFileChooser fileChooser = new JFileChooser(this.model.getSourceDirectory());
        fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return ExternalSignImporterPresenter.this.model.fileFormatIsKnown(f);
            }

            public String getDescription() {
                return ExternalSignImporterPresenter.this.model.getKnownFormats();
            }
        });
        int answer = fileChooser.showOpenDialog(this.ui.getPanel());
        if (answer == 0) {
            try {
                File selected = fileChooser.getSelectedFile();
                if (!selected.isDirectory()) {
                    this.model.setSourceDirectory(selected.getParentFile());
                    this.model.loadSigns(selected);
                } else {
                    this.model.setSourceDirectory(selected);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.ui.getPanel(), "Could not load file " + fileChooser.getSelectedFile().getPath(), "File not loaded", 0);
            }
        }
    }

    public void refreshUI() {
        this.ui.getNextButton().setEnabled(this.model.hasNext());
        this.ui.getPreviousButton().setEnabled(this.model.hasPrevious());
        this.ui.getInsertButton().setEnabled(this.codeFieldIsComplete());
        this.ui.getFlipHorizontallyButton().setEnabled(this.model.getShapeChar() != null);
        this.ui.getFlipVerticallyButton().setEnabled(this.model.getShapeChar() != null);
        this.ui.getCodeField().setEnabled(this.model.getShapeChar() != null);
        this.ui.getFullCadratHeightButton().setEnabled(this.model.getShapeChar() != null);
        this.ui.getImportedSignDisplay().setShape(this.model.getShapeChar());
        this.ui.getReferenceSignDisplay().setShape(this.model.getReferenceShape());
    }

    private boolean codeFieldIsComplete() {
        String txt = this.ui.getCodeField().getText();
        return !"".equals(txt) && this.model.getShapeChar() != null && HieroglyphsManager.isCorrectBasicMdcCode(txt);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.doAction(e.getSource());
    }

    public void resizeVerticallyTo(double y) {
        this.model.resizeVerticallyTo(y);
        this.refreshUI();
    }
}

