/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jsesh.bzr.BzrFontReader;
import jsesh.bzr.BzrFormatException;
import jsesh.bzr.simple.BzrSimpleFont;
import jsesh.bzr.simple.BzrSimpleFontBuilder;
import jsesh.bzr.simple.ShapeChar;
import jsesh.externalFonts.model.SimpleSignSourceModel;

public class BZRSignSource
implements SimpleSignSourceModel {
    int position;
    private BzrSimpleFont font;

    public BZRSignSource(File file) throws IOException, BzrFormatException {
        BzrSimpleFontBuilder builder = new BzrSimpleFontBuilder();
        BzrFontReader reader = new BzrFontReader(builder);
        reader.read(new FileInputStream(file));
        this.font = builder.getFont();
        this.beforeFirst();
    }

    public ShapeChar getCurrentShape() {
        return this.font.getChar(this.position);
    }

    public boolean hasNext() {
        return this.getNextPosition() != -1;
    }

    public boolean hasPrevious() {
        return this.getpreviousPosition() != -1;
    }

    public void next() {
        this.position = this.getNextPosition();
    }

    public void previous() {
        this.position = this.getpreviousPosition();
    }

    private int getNextPosition() {
        int result = -1;
        for (int i = this.position + 1; i < 256 && result == -1; ++i) {
            if (this.font.getChar(i) == null) continue;
            result = i;
        }
        return result;
    }

    private int getpreviousPosition() {
        int result = -1;
        for (int i = this.position - 1; i >= 0 && result == -1; --i) {
            if (this.font.getChar(i) == null) continue;
            result = i;
        }
        return result;
    }

    public String getCurrentCode() {
        return "";
    }

    public void afterLast() {
        this.position = 256;
    }

    public void beforeFirst() {
        this.position = -1;
    }
}

