/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.old;

import com.lowagie.text.DocumentException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jsesh.externalFonts.old.ExternalFontTableModel;
import jsesh.swingUtils.GraphicsUtils;

public class SimpleExternalFontDisplayer
extends JFrame {
    JTable fontDisplay;
    ExternalFontTableModel model = new ExternalFontTableModel();

    public SimpleExternalFontDisplayer() {
        super("Simple font displayer");
        this.fontDisplay = new JTable(this.model);
        this.fontDisplay.setRowHeight(100);
        this.getContentPane().add(new JScrollPane(this.fontDisplay));
        this.pack();
        this.buildMenu();
    }

    private void buildMenu() {
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new AbstractAction("Open"){

            public void actionPerformed(ActionEvent e) {
                JFileChooser choose = new JFileChooser(".");
                if (choose.showOpenDialog(null) == 0) {
                    try {
                        SimpleExternalFontDisplayer.this.loadFont(choose.getSelectedFile().getCanonicalPath());
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(null, "can't open " + choose.getSelectedFile(), "Error", 0);
                        e1.printStackTrace();
                    }
                }
            }
        });
        bar.add(menu);
        this.setJMenuBar(bar);
    }

    private void loadFont(String fileName) throws IOException, DocumentException, FontFormatException {
        FileInputStream in = new FileInputStream(fileName);
        Font f = Font.createFont(0, in);
        f = f.deriveFont(48.0f);
        ((InputStream)in).close();
        this.model.clear();
        int max = 65535;
        for (int i = 0; i <= max; ++i) {
            if (!f.canDisplay((char)i)) continue;
            this.model.add(i, this.buildImage(f, i), "");
        }
        this.fontDisplay.revalidate();
    }

    private ImageIcon buildImage(Font f, int i) {
        BufferedImage img = new BufferedImage(100, 100, 1);
        Graphics2D g = img.createGraphics();
        GraphicsUtils.antialias(g);
        g.setFont(f);
        g.setBackground(Color.WHITE);
        g.setColor(Color.BLACK);
        g.clearRect(0, 0, 100, 100);
        g.drawString("" + (char)i, 10, 40);
        g.dispose();
        ImageIcon result = new ImageIcon(img);
        return result;
    }

    public static void main(String[] args) {
        SimpleExternalFontDisplayer disp = new SimpleExternalFontDisplayer();
        disp.setVisible(true);
        disp.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

