/*
 * Decompiled with CFR 0.152.
 */
package jsesh.fontEditor.model;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import jsesh.fontEditor.model.Forme;
import jsesh.fontEditor.model.Point;

public class Segment
extends Forme {
    private Point a;
    private Point b;

    public Segment(Point a, Point b) {
        this.a = a;
        this.b = b;
    }

    public boolean contient(Point p, double tolerance) {
        double distance;
        if (Point.scalaire(this.a, this.b, this.a, p) > 0.0 && Point.scalaire(this.b, this.a, this.b, p) > 0.0) {
            distance = this.distanceADroiteAuCarre(p);
        } else {
            distance = this.a.distanceCarre(p);
            double dpb = this.b.distanceCarre(p);
            if (dpb < distance) {
                distance = dpb;
            }
        }
        return distance < tolerance;
    }

    public double distanceADroiteAuCarre(Point p) {
        double prodvect = (p.getX() - this.a.getX()) * (this.b.getY() - this.a.getY()) - (p.getY() - this.a.getY()) * (this.b.getX() - this.a.getX());
        double normeAB2 = this.a.distanceCarre(this.b);
        double distance = prodvect * prodvect / normeAB2;
        return distance;
    }

    public void dessiner(Graphics2D g) {
        Line2D.Double s = new Line2D.Double(this.a.getX(), this.a.getY(), this.b.getX(), this.b.getY());
        g.draw(s);
    }

    public Point getA() {
        return this.a;
    }

    public Point getB() {
        return this.b;
    }

    public void deplacer(double dx, double dy) {
        this.a.deplacer(dx, dy);
        this.b.deplacer(dx, dy);
        this.setChanged();
        this.notifyObservers();
    }
}

