/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import jsesh.utils.EnumBase;

public class RTFExportPreferences {
    public static final RTFExportGranularity[] exportModes = new RTFExportGranularity[]{RTFExportGranularity.ONE_LARGE_PICTURE, RTFExportGranularity.GROUPED_CADRATS, RTFExportGranularity.ONE_PICTURE_PER_CADRAT};
    private RTFExportGranularity exportGranularity;
    private int cadratHeight;

    public RTFExportPreferences(int height, RTFExportGranularity granularity) {
        this.cadratHeight = height;
        this.exportGranularity = granularity;
    }

    public RTFExportPreferences() {
        this.exportGranularity = RTFExportGranularity.ONE_PICTURE_PER_CADRAT;
        this.cadratHeight = 20;
    }

    public int getCadratHeight() {
        return this.cadratHeight;
    }

    public void setCadratHeight(int cadratHeight) {
        this.cadratHeight = cadratHeight;
    }

    public RTFExportGranularity getExportGranularity() {
        return this.exportGranularity;
    }

    public void setExportGranularity(RTFExportGranularity exportGranularity) {
        this.exportGranularity = exportGranularity;
    }

    public static class RTFExportGranularity
    extends EnumBase {
        public static final RTFExportGranularity ONE_LARGE_PICTURE = new RTFExportGranularity(0, "as one large picture");
        public static final RTFExportGranularity GROUPED_CADRATS = new RTFExportGranularity(1, "grouped cadrats");
        public static final RTFExportGranularity ONE_PICTURE_PER_CADRAT = new RTFExportGranularity(2, "one picture per cadrat");
        public static final RTFExportGranularity[] GRANULARITIES = new RTFExportGranularity[]{ONE_LARGE_PICTURE, GROUPED_CADRATS, ONE_PICTURE_PER_CADRAT};

        private RTFExportGranularity(int id, String designation) {
            super(id, designation);
        }

        public static RTFExportGranularity getGranularity(int id) {
            return GRANULARITIES[id];
        }
    }
}

