/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.swing.DefaultComboBoxModel;
import jsesh.graphicExport.ExportOptionPanel;
import jsesh.graphicExport.RTFExportPreferences;
import jsesh.graphicExport.RTFExporter;
import jsesh.graphicExport.RTFFilePreferencesForm;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.mdcDisplayer.swing.units.LengthUnit;
import jsesh.mdcDisplayer.swing.units.UnitMaintainter;
import jsesh.swingUtils.FileButtonMapper;

public class RTFExporterUI {
    File file;
    RTFExportPreferences rtfPreferences;

    public RTFExporterUI(File file, RTFExportPreferences preferences) {
        this.file = file;
        this.rtfPreferences = preferences;
    }

    public void exportModel(DrawingSpecifications drawingSpecifications, TopItemList model) {
        RTFExporter exporter = new RTFExporter();
        exporter.setDrawingSpecifications(drawingSpecifications);
        exporter.setRtfPreferences(this.rtfPreferences);
        exporter.setViewBuilder(new SimpleViewBuilder());
        try {
            FileOutputStream out = new FileOutputStream(this.file);
            exporter.ExportModelTo(model, out);
        }
        catch (FileNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    public void setFile(File currentOutputDirectory, String fname) {
        this.file = new File(currentOutputDirectory, fname);
    }

    public File getFile() {
        return this.file;
    }

    public ExportOptionPanel getOptionPanel(Component parent, String title) {
        return new RTFExportOptionPanel(parent, title);
    }

    public RTFExportPreferences getRtfPreferences() {
        return this.rtfPreferences;
    }

    public void setRtfPreferences(RTFExportPreferences rtfPreferences) {
        this.rtfPreferences = rtfPreferences;
    }

    public void setFile(File file) {
        this.file = file;
    }

    private class RTFExportOptionPanel
    extends ExportOptionPanel {
        RTFFilePreferencesForm form;
        LengthUnit unit;

        public RTFExportOptionPanel(Component parent, String title) {
            super(parent, title);
            this.unit = LengthUnit.POINT;
            this.form = new RTFFilePreferencesForm();
            this.form.fileNameField.setValue(RTFExporterUI.this.file);
            FileButtonMapper mapper = new FileButtonMapper(this.form.browse, this.form.fileNameField);
            LengthUnit.attachToCombobox(this.form.unitField, this.unit);
            this.form.cadratHeightField.setValue(this.unit.convert(RTFExporterUI.this.rtfPreferences.getCadratHeight()));
            UnitMaintainter.linkUnitsToValueField(this.form.unitField, this.form.cadratHeightField);
            this.form.exportModeField.setModel(new DefaultComboBoxModel<RTFExportPreferences.RTFExportGranularity>(RTFExportPreferences.RTFExportGranularity.GRANULARITIES));
            this.form.exportModeField.setSelectedItem(RTFExportPreferences.RTFExportGranularity.GROUPED_CADRATS);
            this.add(this.form);
        }

        public void setOptions() {
            RTFExporterUI.this.file = (File)this.form.fileNameField.getValue();
            RTFExporterUI.this.rtfPreferences.setCadratHeight(this.getCadratHeight());
            RTFExporterUI.this.rtfPreferences.setExportGranularity((RTFExportPreferences.RTFExportGranularity)this.form.exportModeField.getSelectedItem());
        }

        private int getCadratHeight() {
            return (int)((Double)this.form.cadratHeightField.getValue() * ((LengthUnit)this.form.unitField.getSelectedItem()).getPointsValue());
        }
    }
}

