/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import jsesh.graphicExport.BaseGraphics2DFactory;
import jsesh.graphicExport.ExportData;
import jsesh.graphics.generic.BaseGraphics2D;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.draw.ViewDrawer;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class SelectionExporter {
    private ExportData exportData;
    private BaseGraphics2DFactory graphicsFactory;
    private Color background;
    private DrawingSpecifications actualDrawingSpecifications;

    public SelectionExporter(ExportData exportData, BaseGraphics2DFactory gf) {
        this.exportData = exportData;
        this.graphicsFactory = gf;
        this.background = Color.WHITE;
    }

    public void exportSelection() throws IOException {
        SimpleViewBuilder builder = new SimpleViewBuilder();
        this.actualDrawingSpecifications = this.exportData.getDrawingSpecifications().copy();
        this.actualDrawingSpecifications.setLeftMargin(0.0f);
        this.actualDrawingSpecifications.setTopMargin(0.0f);
        this.exportZone(builder, this.exportData.getStart().getIndex(), this.exportData.getEnd().getIndex());
        this.actualDrawingSpecifications = null;
    }

    public void exportToPages() throws IOException {
        SimpleViewBuilder builder = new SimpleViewBuilder();
        this.actualDrawingSpecifications = this.exportData.getDrawingSpecifications().copy();
        int start = 0;
        TopItemList l = this.exportData.getTopItemList();
        while (start < l.getNumberOfChildren()) {
            int end;
            for (end = start + 1; end < l.getNumberOfChildren() && !(l.getChildAt(end) instanceof PageBreak); ++end) {
            }
            this.exportZone(builder, start, end);
            start = end;
        }
        this.actualDrawingSpecifications = null;
    }

    private void exportZone(SimpleViewBuilder builder, int start, int end) throws IOException {
        MDCView view = builder.buildView(this.exportData.getTopItemList(), start, end, this.actualDrawingSpecifications);
        this.graphicsFactory.setDimension(this.getScaledDimensions(view));
        BaseGraphics2D g = this.graphicsFactory.buildGraphics();
        g.setBackground(this.background);
        g.clearRect(0, 0, (int)this.getScaledDimensions(view).getWidth(), (int)this.getScaledDimensions(view).getHeight());
        g.scale(this.exportData.getScale(), this.exportData.getScale());
        ViewDrawer drawer = new ViewDrawer();
        drawer.setShadeAfter(false);
        drawer.draw(g, view, this.exportData.getDrawingSpecifications());
        g.dispose();
    }

    private Dimension getScaledDimensions(MDCView view) {
        double w = (double)view.getWidth() * this.exportData.getScale();
        double h = (double)view.getHeight() * this.exportData.getScale();
        return new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
    }

    public BaseGraphics2DFactory getGraphicsFactory() {
        return this.graphicsFactory;
    }

    public void setGraphicsFactory(BaseGraphics2DFactory graphicsFactory) {
        this.graphicsFactory = graphicsFactory;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setTransparency(boolean transparency) {
    }
}

