/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphics.generic;

import jsesh.graphics.generic.RandomAccessStream;

public class RandomAccessByteArray
implements RandomAccessStream {
    private static final int CHUNK_SIZE = 2048;
    private int size = 0;
    private int pos = 0;
    private byte[] data = new byte[2048];

    public void seek(int i) {
        this.ensureExist(i);
        this.pos = i;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    private void ensureExist(int i) {
        if (i >= this.data.length) {
            int newSize;
            for (newSize = this.data.length; i >= newSize; newSize <<= 1) {
            }
            byte[] newArray = new byte[newSize];
            System.arraycopy(this.data, 0, newArray, 0, this.data.length);
            this.data = newArray;
        }
    }

    public void close() {
    }

    public void write(int s0) {
        this.ensureExist(this.pos);
        this.data[this.pos] = (byte)s0;
        ++this.pos;
        if (this.pos > this.size) {
            this.size = this.pos;
        }
    }

    public byte[] getByteArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.data, 0, result, 0, this.size);
        return result;
    }

    public void setLength(int i) {
        this.size = i;
        if (this.pos > this.size) {
            this.pos = this.size;
        }
    }

    public static void main(String[] args) {
        RandomAccessByteArray test = new RandomAccessByteArray();
        test.write(0);
        test.write(10);
        test.write(255);
        test.seek(500);
        test.write(128);
        test.seek(0);
        test.write(9);
        byte[] b = test.getByteArray();
        for (int i = 0; i < b.length; ++i) {
            System.out.println(b[i]);
        }
    }
}

