/*
 * Decompiled with CFR 0.152.
 */
package jsesh.hieroglyphs;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.xml.parsers.FactoryConfigurationError;
import jsesh.bzr.simple.ShapeChar;
import jsesh.hieroglyphs.CompositeHieroglyphicFontManager;
import jsesh.hieroglyphs.DirectoryHieroglyphicFontManager;
import jsesh.hieroglyphs.HieroglyphicFontManager;
import jsesh.hieroglyphs.HieroglyphsManager;
import jsesh.hieroglyphs.MemoryHieroglyphicFontManager;
import jsesh.hieroglyphs.ResourcesHieroglyphicFontManager;

public class DefaultHieroglyphicFontManager
implements HieroglyphicFontManager {
    private static final String GLYPH_DIRECTORY = "glyphDirectory";
    private static DefaultHieroglyphicFontManager instance = null;
    private CompositeHieroglyphicFontManager composite = new CompositeHieroglyphicFontManager();
    private DirectoryHieroglyphicFontManager directoryManager = new DirectoryHieroglyphicFontManager(new File(""));
    private ResourcesHieroglyphicFontManager resourcesHieroglyphicFontManager;

    private DefaultHieroglyphicFontManager() {
        this.composite.addHieroglyphicFontManager(this.directoryManager);
        this.resourcesHieroglyphicFontManager = new ResourcesHieroglyphicFontManager("/jseshResources/glyphs");
        this.composite.addHieroglyphicFontManager(this.resourcesHieroglyphicFontManager);
        this.composite.addHieroglyphicFontManager(new MemoryHieroglyphicFontManager());
        this.initDirectory();
    }

    public static synchronized DefaultHieroglyphicFontManager getInstance() {
        if (instance == null) {
            instance = new DefaultHieroglyphicFontManager();
        }
        return instance;
    }

    public void addHieroglyphicFontManager(HieroglyphicFontManager manager) {
        this.composite.addHieroglyphicFontManager(manager);
    }

    public ShapeChar get(String code) {
        String newCode = code;
        if (!HieroglyphsManager.isCorrectBasicMdcCode(code)) {
            newCode = HieroglyphsManager.getInstance().getCanonicalCode(code);
        }
        if (newCode == null) {
            newCode = code;
        }
        return this.composite.get(newCode);
    }

    public Set getCodes() {
        return this.composite.getCodes();
    }

    public boolean hasNewSigns() {
        return this.composite.hasNewSigns();
    }

    public File getDirectory() {
        return this.directoryManager.getDirectory();
    }

    public void setDirectory(File directory) {
        this.directoryManager.setDirectory(directory);
        String path = directory.getAbsolutePath();
        try {
            path = directory.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.put(GLYPH_DIRECTORY, path);
    }

    private void initDirectory() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            String dirPath = preferences.get(GLYPH_DIRECTORY, "");
            this.directoryManager.setDirectory(new File(dirPath));
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    public void insertNewSign(String text, ShapeChar shapeChar) {
        this.directoryManager.insertNewSign(text, shapeChar);
    }
}

