/*
 * Decompiled with CFR 0.152.
 */
package jsesh.hieroglyphs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsesh.bzr.BzrFontReader;
import jsesh.bzr.simple.BzrSimpleFont;
import jsesh.bzr.simple.BzrSimpleFontBuilder;
import jsesh.bzr.simple.ShapeChar;
import jsesh.swingUtils.GraphicsUtils;

public class DemoFontDisplayer
extends JFrame {
    BzrSimpleFont font = null;
    int pos = 0;

    private void loadFont() {
        FileDialog file = new FileDialog((Frame)this, "choose a bzr font");
        file.setVisible(true);
        System.out.println(file.getFile());
        BzrSimpleFontBuilder builder = new BzrSimpleFontBuilder();
        BzrFontReader reader = new BzrFontReader(builder);
        try {
            reader.read(new FileInputStream(new File(file.getDirectory(), file.getFile())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.font = builder.getFont();
        this.pos = -1;
    }

    public DemoFontDisplayer() {
        super("Font Display");
        this.setSize(300, 300);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        this.setJMenuBar(this.createMenu());
        this.getContentPane().add(new JScrollPane(new Canvas()));
    }

    public static void main(String[] args) {
        DemoFontDisplayer f = new DemoFontDisplayer();
        f.setVisible(true);
    }

    protected JMenuBar createMenu() {
        JMenuBar mb = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.add(new AbstractAction("Load"){

            public void actionPerformed(ActionEvent e) {
                DemoFontDisplayer.this.loadFont();
            }
        });
        menu.add(new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        mb.add(menu);
        return mb;
    }

    class Canvas
    extends JPanel {
        public Canvas() {
            this.setSize(this.getPreferredSize());
            this.setBackground(Color.white);
        }

        public Dimension getPreferredSize() {
            return new Dimension(600, 600);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            if (DemoFontDisplayer.this.font != null) {
                GraphicsUtils.antialias(g);
                g2d.scale(2.0, 2.0);
                int n = 0;
                for (int i = 0; i < 256; ++i) {
                    ShapeChar c = DemoFontDisplayer.this.font.getChar(i);
                    if (c == null) continue;
                    g2d.fill(c.getShape());
                    g2d.translate(20.0, 0.0);
                    if (++n % 10 != 0) continue;
                    g2d.translate(-200.0, 20.0);
                }
            }
        }
    }
}

