/*
 * Decompiled with CFR 0.152.
 */
package jsesh.hieroglyphs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import jsesh.bzr.simple.ShapeChar;
import jsesh.hieroglyphs.DefaultHieroglyphicFontManager;
import jsesh.swingUtils.GraphicsUtils;

public class HieroglyphicBitmapBuilder {
    private int size;
    private double maxSize;
    private boolean transparent;
    private boolean fit;
    private Component component = null;
    private int border;

    public HieroglyphicBitmapBuilder() {
        DefaultHieroglyphicFontManager manager = DefaultHieroglyphicFontManager.getInstance();
        ShapeChar A1 = manager.get("A1");
        this.maxSize = A1.getBbox().getHeight();
        this.size = 50;
        this.transparent = false;
        this.border = 4;
    }

    public HieroglyphicBitmapBuilder(double maxSize, int imageSize, boolean transparent) {
        this.maxSize = maxSize;
        this.size = imageSize;
        this.transparent = transparent;
    }

    public BufferedImage buildSignBitmap(ShapeChar glyph) {
        float scale = (float)((double)this.size / this.maxSize);
        int colorModel = 10;
        Color backGroundColor = Color.WHITE;
        if (this.transparent) {
            colorModel = 2;
            backGroundColor = new Color(0, 0, 0, 1);
        }
        int actualWidth = this.size;
        int actualHeight = this.size;
        if (this.isFit()) {
            actualWidth = this.border + (int)(1.0 + glyph.getBbox().getWidth() * (double)scale);
            actualHeight = this.border + (int)(1.0 + glyph.getBbox().getHeight() * (double)scale);
        }
        double mx = ((double)actualWidth - (double)scale * glyph.getBbox().getWidth()) / 2.0;
        double my = ((double)actualHeight - (double)scale * glyph.getBbox().getHeight()) / 2.0;
        BufferedImage img = this.component != null ? this.component.getGraphicsConfiguration().createCompatibleImage(actualWidth, actualHeight) : new BufferedImage(actualWidth, actualHeight, colorModel);
        Graphics2D g = img.createGraphics();
        GraphicsUtils.antialias(g);
        g.setBackground(backGroundColor);
        g.setColor(Color.BLACK);
        g.clearRect(0, 0, img.getWidth(), img.getHeight());
        glyph.draw(g, mx, my, scale, scale, 0.0f);
        g.dispose();
        return img;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(double maxSize) {
        this.maxSize = maxSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void setFit(boolean fit) {
        this.fit = fit;
    }

    public boolean isFit() {
        return this.fit;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }
}

