/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.lex;

public class MDCModifier {
    private String name;
    private Integer intValue;

    public static MDCModifier buildMDCModifierFromString(String str) {
        char c;
        int endPos;
        for (endPos = 1; endPos < str.length() && (Character.isLetter(c = str.charAt(endPos)) || c == '?'); ++endPos) {
        }
        String name = str.substring(1, endPos);
        Integer value = null;
        if (endPos < str.length()) {
            value = new Integer(Integer.parseInt(str.substring(endPos, str.length())));
        }
        return new MDCModifier(name, value);
    }

    public MDCModifier(String name, Integer intValue) {
        this.setName(name);
        this.setIntValue(intValue);
    }

    public MDCModifier(String name) {
        this.setName(name);
        this.setIntValue(null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        this.name = argName;
    }

    public Integer getIntValue() {
        return this.intValue;
    }

    public void setIntValue(Integer argIntValue) {
        this.intValue = argIntValue;
    }

    public String toString() {
        return "\\" + this.getName() + "=" + this.getIntValue();
    }

    public static void main(String[] a) {
        MDCModifier m = MDCModifier.buildMDCModifierFromString("\\");
        System.out.println("" + m);
        m = MDCModifier.buildMDCModifierFromString("\\?");
        System.out.println("" + m);
        m = MDCModifier.buildMDCModifierFromString("\\80");
        System.out.println("" + m);
        m = MDCModifier.buildMDCModifierFromString("\\tyut800");
        System.out.println("" + m);
        m = MDCModifier.buildMDCModifierFromString("\\tyut");
        System.out.println("" + m);
        m = MDCModifier.buildMDCModifierFromString("\\R-10");
        System.out.println("" + m);
    }
}

