/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import jsesh.mdc.interfaces.ComplexLigatureInterface;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.HorizontalListElement;
import jsesh.mdc.model.InnerGroup;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementVisitor;

public class ComplexLigature
extends HorizontalListElement
implements ComplexLigatureInterface {
    private boolean hasBeforeGroup;
    private boolean hasAfterGroup;

    public ComplexLigature(InnerGroup g1, Hieroglyph h, InnerGroup g2) {
        this.hasBeforeGroup = g1 != null;
        boolean bl = this.hasAfterGroup = g2 != null;
        if (this.hasBeforeGroup) {
            this.addChild(g1);
        }
        this.addChild(h);
        if (this.hasAfterGroup) {
            this.addChild(g2);
        }
    }

    public void accept(ModelElementVisitor v) {
        v.visitComplexLigature(this);
    }

    private int computeLigatureRank() {
        int result = 0;
        if (this.hasBeforeGroup) {
            result += 2;
        }
        if (this.hasAfterGroup) {
            ++result;
        }
        return result;
    }

    public int compareToAux(ModelElement e) {
        ComplexLigature lig2 = (ComplexLigature)e;
        int result = this.computeLigatureRank() - lig2.computeLigatureRank();
        if (result == 0) {
            result = this.compareContents(e);
        }
        return result;
    }

    public ModelElement deepCopy() {
        InnerGroup copy1 = null;
        InnerGroup copy2 = null;
        if (this.hasBeforeGroup) {
            copy1 = (InnerGroup)this.getBeforeGroup().deepCopy();
        }
        if (this.hasAfterGroup) {
            copy2 = (InnerGroup)this.getAfterGroup().deepCopy();
        }
        return new ComplexLigature(copy1, (Hieroglyph)this.getHieroglyph().deepCopy(), copy2);
    }

    public Hieroglyph getHieroglyph() {
        int hindex = 0;
        if (this.hasBeforeGroup) {
            hindex = 1;
        }
        return (Hieroglyph)this.getChildAt(hindex);
    }

    public InnerGroup getBeforeGroup() {
        if (this.hasBeforeGroup) {
            return (InnerGroup)this.getChildAt(0);
        }
        return null;
    }

    public InnerGroup getAfterGroup() {
        if (this.hasAfterGroup) {
            if (this.hasBeforeGroup) {
                return (InnerGroup)this.getChildAt(2);
            }
            return (InnerGroup)this.getChildAt(1);
        }
        return null;
    }
}

