/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model;

import jsesh.mdc.interfaces.ModifierListInterface;
import jsesh.mdc.model.EmbeddedModelElement;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementVisitor;
import jsesh.mdc.model.Modifier;
import jsesh.mdc.model.NoSuchModifierException;
import jsesh.mdc.model.TopItem;

public class ModifiersList
extends EmbeddedModelElement
implements ModifierListInterface {
    private int angle = 0;
    private boolean reversed = false;
    private int scale = 100;

    private static int getArity(Modifier m) {
        if (m.getValue() == null) {
            return 0;
        }
        return 1;
    }

    public void accept(ModelElementVisitor v) {
        v.visitModifierList(this);
    }

    private void addAux(Modifier m) {
        boolean notFound = true;
        Modifier m1 = this.getModifierFrom(m.getName(), ModifiersList.getArity(m));
        if (m1 == null) {
            this.addChild(m);
        } else if (ModifiersList.getArity(m) == 1) {
            m1.setValue(m.getValue());
        }
    }

    public TopItem buildTopItem() {
        return null;
    }

    public int compareToAux(ModelElement e) {
        ModifiersList l = (ModifiersList)e;
        int result = this.angle - l.angle;
        if (result == 0) {
            result = (this.reversed ? 1 : 0) - (l.reversed ? 1 : 0);
            if (result == 0 && (result = this.scale - l.scale) == 0) {
                result = this.compareContents(l);
            }
        }
        return result;
    }

    public ModelElement deepCopy() {
        ModifiersList result = new ModifiersList();
        result.angle = this.angle;
        result.reversed = this.reversed;
        result.scale = this.scale;
        this.copyContentTo(result);
        return result;
    }

    public int getAngle() {
        return this.angle;
    }

    public boolean getBoolean(String name) {
        if (name.equals("")) {
            return this.reversed;
        }
        Modifier m = this.getModifierFrom(name, 0);
        return m != null;
    }

    public int getInteger(String name) throws NoSuchModifierException {
        Modifier m = this.getModifierFrom(name, 1);
        if (m != null) {
            return m.getValue();
        }
        throw new NoSuchModifierException(name);
    }

    public int getIntegerWithDefault(String name, int defaultValue) {
        Modifier m = this.getModifierFrom(name, 1);
        if (m != null) {
            return m.getValue();
        }
        return defaultValue;
    }

    public Modifier getModifierAt(int i) {
        return (Modifier)this.getChildAt(i);
    }

    private Modifier getModifierFrom(String name, int arity) {
        Modifier result = null;
        for (int i = 0; result == null && i < this.getNumberOfChildren(); ++i) {
            Modifier m1 = (Modifier)this.getChildAt(i);
            if (!name.equals(m1.getName()) || arity != -1 && ModifiersList.getArity(m1) != arity) continue;
            result = m1;
        }
        return result;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean hasInteger(String name) {
        Modifier m = this.getModifierFrom(name, 1);
        return m != null;
    }

    public void includeModifier(Modifier m) {
        if ("".equals(m.getName())) {
            if (m.getValue() == null) {
                this.reversed = true;
            } else {
                this.setScale(m.getValue());
            }
        } else if (m.getValue() != null) {
            if (m.getName().equals("r")) {
                this.angle = m.getValue() * 90;
            } else if (m.getName().equals("t")) {
                this.angle = m.getValue() * 90;
                this.reversed = true;
            } else if (m.getName().equals("R")) {
                this.angle = m.getValue() % 360;
                if (this.angle < 0) {
                    this.angle += 360;
                }
            } else if (m.getName().equals("s")) {
                double scale = 100.0;
                for (int i = 0; i < m.getValue(); ++i) {
                    scale /= 1.4142136;
                }
                this.setScale((int)scale);
            } else {
                this.addAux(m);
            }
        } else {
            this.addAux(m);
        }
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void removeModifier(Modifier m) {
        if ("".equals(m.getName())) {
            if (m.getValue() == null) {
                this.reversed = false;
            } else {
                this.setScale(100);
            }
        } else if (m.getValue() != null) {
            if (m.getName().equals("r")) {
                this.angle = 0;
            } else if (m.getName().equals("t")) {
                this.angle = 0;
                this.reversed = false;
            } else if (m.getName().equals("R")) {
                this.angle = 0;
            } else {
                this.removeChild(m);
            }
        } else {
            this.removeChild(m);
        }
    }

    public void setAngle(int a) {
        this.angle = a % 360;
        if (a < 0) {
            a += 360;
        }
        this.notifyModification();
    }

    public void setBoolean(String name, boolean value) {
        if (value) {
            this.includeModifier(new Modifier(name, null));
        } else {
            this.removeModifier(new Modifier(name, null));
        }
    }

    public void setInteger(String name, int val) {
        this.includeModifier(new Modifier(name, new Integer(val)));
    }

    public void setReversed(boolean _reversed) {
        this.reversed = _reversed;
        this.notifyModification();
    }

    public void setScale(int i) {
        this.scale = i;
        this.notifyModification();
    }

    public void unSetInteger(String name) {
        Modifier m = this.getModifierFrom(name, 1);
        this.removeChild(m);
    }
}

