/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model.utilities;

import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.ComplexLigature;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementDeepAdapter;
import jsesh.mdc.model.TopItemList;

public class ComplexLigatureExtractor {
    private ComplexLigature complexLigature;
    private boolean foundOtherElements;
    private boolean foundTooManyLigatures;

    public void extract(ModelElement elt) {
        this.complexLigature = null;
        this.foundOtherElements = false;
        this.foundTooManyLigatures = false;
        ComplexLigatureExtractorAux aux = new ComplexLigatureExtractorAux();
        elt.accept(aux);
        if (this.foundTooManyLigatures) {
            this.complexLigature = null;
        }
    }

    public ComplexLigature getComplexLigature() {
        return this.complexLigature;
    }

    public boolean foundOtherElements() {
        return this.foundOtherElements;
    }

    private class ComplexLigatureExtractorAux
    extends ModelElementDeepAdapter {
        private ComplexLigatureExtractorAux() {
        }

        public void visitComplexLigature(ComplexLigature ligature) {
            if (ComplexLigatureExtractor.this.complexLigature != null) {
                ComplexLigatureExtractor.this.foundTooManyLigatures = true;
            } else {
                ComplexLigatureExtractor.this.complexLigature = (ComplexLigature)ligature.deepCopy();
            }
        }

        public void visitDefault(ModelElement t) {
            ComplexLigatureExtractor.this.foundOtherElements = true;
            super.visitDefault(t);
        }

        public void visitBasicItemList(BasicItemList l) {
            super.visitDefault(l);
        }

        public void visitHBox(HBox b) {
            super.visitDefault(b);
        }

        public void visitCadrat(Cadrat c) {
            super.visitDefault(c);
        }

        public void visitTopItemList(TopItemList t) {
            super.visitDefault(t);
        }
    }
}

