/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc.model.utilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsesh.mdc.model.BasicItemList;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.HBox;
import jsesh.mdc.model.InnerGroup;
import jsesh.mdc.model.ModelElement;
import jsesh.mdc.model.ModelElementDeepAdapter;
import jsesh.mdc.model.TopItemList;

public class InnerGroupExtractor {
    private boolean foundOtherElements;
    private List innerGroups;

    public void extract(List list) {
        this.foundOtherElements = false;
        this.innerGroups = new ArrayList();
        InnerGroupExtractorAux aux = new InnerGroupExtractorAux();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ModelElement elt = (ModelElement)iterator.next();
            elt.accept(aux);
        }
    }

    public boolean foundOtherElements() {
        return this.foundOtherElements;
    }

    public List getInnerGroups() {
        return this.innerGroups;
    }

    private class InnerGroupExtractorAux
    extends ModelElementDeepAdapter {
        private InnerGroupExtractorAux() {
        }

        public void visitInnerGroup(InnerGroup g) {
            InnerGroupExtractor.this.innerGroups.add(g.deepCopy());
        }

        public void visitDefault(ModelElement t) {
            super.visitDefault(t);
            InnerGroupExtractor.this.foundOtherElements = true;
        }

        public void visitBasicItemList(BasicItemList l) {
            super.visitDefault(l);
        }

        public void visitHBox(HBox b) {
            super.visitDefault(b);
        }

        public void visitCadrat(Cadrat c) {
            super.visitDefault(c);
        }

        public void visitTopItemList(TopItemList t) {
            super.visitDefault(t);
        }
    }
}

