/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.StringReader;
import jsesh.mdc.MDCParserModelGenerator;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.utils.MDCSyntaxError;
import jsesh.mdcDisplayer.draw.ViewDrawer;
import jsesh.mdcDisplayer.layout.MDCEditorKit;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.swingUtils.GraphicsUtils;

public class MDCDrawingFacade {
    private boolean philologySign = true;
    private DrawingSpecifications drawingSpecifications = null;
    int maxWidth;
    int maxHeight;
    private int cadratHeight;

    public BufferedImage createImage(String mdcCodes) throws MDCSyntaxError {
        MDCParserModelGenerator gen = new MDCParserModelGenerator();
        gen.setPhilologyAsSigns(this.isPhilologySign());
        TopItemList t = gen.parse(new StringReader(mdcCodes));
        this.maxWidth = 2000;
        this.maxHeight = 2000;
        this.cadratHeight = 20;
        return this.createImage(t);
    }

    public BufferedImage createImage(TopItemList t) {
        this.drawingSpecifications = this.getDrawingSpecifications();
        SimpleViewBuilder viewBuilder = new SimpleViewBuilder();
        MDCView v = viewBuilder.buildView(t, this.drawingSpecifications);
        double scale = this.getScale();
        int width = (int)Math.ceil((double)v.getWidth() * scale) + 2;
        int height = (int)Math.ceil((double)v.getHeight() * scale) + 2;
        if (width > this.maxWidth) {
            width = this.maxWidth;
        }
        if (height > this.maxHeight) {
            height = this.maxHeight;
        }
        BufferedImage result = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, width, height);
        g.scale(scale, scale);
        GraphicsUtils.antialias(g);
        g.setColor(Color.BLACK);
        ViewDrawer drawer = new ViewDrawer();
        drawer.draw(g, v, this.drawingSpecifications);
        g.dispose();
        return result;
    }

    public boolean isPhilologySign() {
        return this.philologySign;
    }

    private double getScale() {
        return (float)this.cadratHeight / this.drawingSpecifications.getBaseLength();
    }

    public void setPhilologySign(boolean philologySign) {
        this.philologySign = philologySign;
    }

    public DrawingSpecifications getDrawingSpecifications() {
        if (this.drawingSpecifications == null) {
            return MDCEditorKit.getBasicMDCEditorKit().getDrawingSpecifications();
        }
        return this.drawingSpecifications;
    }

    public void setDrawingSpecifications(DrawingSpecifications drawingSpecifications) {
        this.drawingSpecifications = drawingSpecifications;
    }

    public void setMaxSize(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
    }

    public void setCadratHeight(int cadratHeight) {
        if (this.drawingSpecifications != null) {
            this.cadratHeight = cadratHeight;
        }
    }
}

