/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.awt.image.BufferedImage;
import java.util.TreeMap;
import jsesh.mdc.model.ModelElement;

class PictureCache {
    private Element[] elements;
    private TreeMap viewMap;
    private int maxSize;
    private int pos = 0;
    private int PICSIZE = 40;

    public PictureCache(int size) {
        this.maxSize = size;
        this.reset();
    }

    public void reset() {
        this.elements = new Element[this.maxSize];
        this.viewMap = new TreeMap();
        this.pos = 0;
        for (int i = 0; i < this.maxSize; ++i) {
            this.elements[i] = new Element(null, new BufferedImage(this.PICSIZE, this.PICSIZE, 2));
        }
    }

    public void put(ModelElement e, BufferedImage img) {
        e = e.deepCopy();
        if (this.elements[this.pos] != null && this.elements[this.pos].model != null) {
            this.remove(this.elements[this.pos].model);
        }
        this.viewMap.put(e, new Integer(this.pos));
        this.elements[this.pos] = new Element(e, img);
        this.pos = (this.pos + 1) % this.maxSize;
    }

    public BufferedImage get(ModelElement e) {
        BufferedImage result = null;
        Integer i = (Integer)this.viewMap.get(e);
        if (i != null) {
            result = this.elements[i.intValue()].image;
        }
        return result;
    }

    public void remove(ModelElement e) {
        Object result = null;
        Integer i = (Integer)this.viewMap.get(e);
        if (i != null) {
            this.viewMap.remove(e);
        }
    }

    public BufferedImage createImage(int width, int height) {
        if (width > this.PICSIZE || height > this.PICSIZE) {
            return null;
        }
        return new BufferedImage(this.PICSIZE, this.PICSIZE, 2);
    }

    static class Element {
        ModelElement model;
        BufferedImage image;

        public Element(ModelElement model, BufferedImage image) {
            this.model = model;
            this.image = image;
        }
    }
}

