/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import jsesh.bzr.simple.ShapeChar;
import jsesh.hieroglyphs.DefaultHieroglyphicFontManager;
import jsesh.hieroglyphs.HieroglyphicFontManager;
import jsesh.mdcDisplayer.draw.HieroglyphsDrawer;
import jsesh.mdcDisplayer.layout.ComplexLigatureLayout;
import jsesh.mdcDisplayer.mdcView.MDCView;

public class SimpleHieroglyphicDrawer
implements HieroglyphsDrawer {
    private static final String DEFAULT_CODE = "A1";
    private HieroglyphicFontManager fontManager = DefaultHieroglyphicFontManager.getInstance();
    private Map nonHieroglyphs = new HashMap();

    public SimpleHieroglyphicDrawer() {
        Rectangle2D specA1 = this.fontManager.get(DEFAULT_CODE).getBbox();
        float w = (float)specA1.getWidth();
        float h = (float)specA1.getHeight();
        this.nonHieroglyphs.put("/", new Rectangle2D.Float(0.0f, 0.0f, w / 2.0f, h / 2.0f));
        this.nonHieroglyphs.put("//", new Rectangle2D.Float(0.0f, 0.0f, w, h));
        this.nonHieroglyphs.put("h/", new Rectangle2D.Float(0.0f, 0.0f, w, h / 2.0f));
        this.nonHieroglyphs.put("v/", new Rectangle2D.Float(0.0f, 0.0f, w / 2.0f, h));
    }

    public void draw(Graphics2D g, String code, int angle, MDCView view) {
        ShapeChar glyph = this.fontManager.get(code);
        if (glyph == null) {
            Rectangle2D r = g.getFont().getStringBounds(code, new FontRenderContext(new AffineTransform(), true, true));
            double w = view.getWidth() / view.getXScale();
            g.scale(w / r.getWidth(), w / r.getWidth());
            if (code.length() > 0) {
                g.drawString(code, (float)(-r.getMinX()), (float)(-r.getMinY()));
            }
        } else {
            glyph.draw(g, 0.0, 0.0, 1.0, 1.0, (float)((double)angle * Math.PI / 180.0));
        }
    }

    public Rectangle2D getBBox(String code) {
        Rectangle2D result = null;
        ShapeChar glyph = this.fontManager.get(code);
        if (glyph != null) {
            result = glyph.getBbox();
        }
        return result;
    }

    public Shape getShape(String code) {
        Shape result = null;
        ShapeChar glyph = this.fontManager.get(code);
        result = glyph != null ? glyph.getShape() : this.getBBox(code);
        return result;
    }

    public Shape getTransformedShape(String code, double x, double y, double xscale, double yscale, int angle, boolean reversed) {
        Shape result = null;
        ShapeChar glyph = this.fontManager.get(code);
        result = glyph != null ? glyph.getTransformedShape(x, y, xscale, yscale, (double)angle * Math.PI / 180.0) : this.getBBox(code);
        return result;
    }

    public Area getSignArea(String code, double x, double y, double xscale, double yscale, int angle, boolean reversed) {
        Area result = null;
        ShapeChar glyph = this.fontManager.get(code);
        result = glyph != null ? glyph.getSignArea(x, y, xscale, yscale, (double)angle * Math.PI / 180.0) : new Area();
        return result;
    }

    public boolean isKnown(String code) {
        return this.fontManager.get(code) != null;
    }

    public Rectangle2D getLigatureArea(int i, String code) {
        ShapeChar glyph = this.fontManager.get(code);
        Rectangle2D result = null;
        if (glyph != null && (result = glyph.getZone(i)) == null) {
            ComplexLigatureLayout l = new ComplexLigatureLayout(glyph);
            result = l.getLigatureArea(i);
        }
        return result;
    }
}

