/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.constants.TextOrientation;
import jsesh.mdc.model.Cadrat;
import jsesh.mdc.model.MDCPosition;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.draw.ElementDrawer;
import jsesh.mdcDisplayer.draw.MDCCaret;
import jsesh.mdcDisplayer.draw.PictureCache;
import jsesh.mdcDisplayer.draw.SimpleElementDrawer;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class ViewDrawer {
    private PictureCache cache;
    private boolean clip;
    private MDCCaret cursor = null;
    private boolean debug = false;
    private ElementDrawer elementDrawer;
    private DrawingSpecifications drawingSpecifications;
    transient Rectangle temporaryRectangle = new Rectangle();
    private AffineTransform temporaryTransform = null;

    public ViewDrawer() {
        this(new SimpleElementDrawer());
    }

    public ViewDrawer(ElementDrawer e) {
        this.setClip(false);
        this.elementDrawer = e;
        this.drawingSpecifications = null;
        this.setCached(false);
    }

    public void draw(Graphics2D g, MDCView view, DrawingSpecifications ds) {
        this.DrawViewAndCursor(g, view, null, ds);
    }

    public void draw(Graphics2D g, MDCView view, DrawingSpecifications ds, MDCPosition start, MDCPosition end) {
        this.DrawViewAndCursor(g, view, null, ds, start, end);
    }

    private void drawDebug(Graphics2D g, MDCView v) {
        if (v.getSubViews() != null && v.getSubViews().size() != 0) {
            if (v.getModel() instanceof Cadrat) {
                g.setColor(Color.GREEN);
                g.setStroke(new BasicStroke(0.4f));
                g.draw(new Line2D.Double(0.0, v.getHeight(), v.getWidth(), 0.0));
            } else if (v.getModel() instanceof TopItemList) {
                g.setStroke(new BasicStroke(1.0f));
                g.setColor(Color.MAGENTA);
            } else {
                g.setStroke(new BasicStroke(0.1f));
                g.setColor(Color.RED);
            }
            g.draw(new Rectangle2D.Double(0.0, 0.0, v.getWidth(), v.getHeight()));
        } else {
            g.setColor(Color.YELLOW);
            g.setStroke(new BasicStroke(0.3f, 1, 1, 0.5f));
            g.draw(new Line2D.Double(0.0, 0.0, v.getWidth(), v.getHeight()));
            g.draw(new Rectangle2D.Double(0.0, 0.0, v.getWidth(), v.getHeight()));
        }
    }

    private boolean drawFromCache(Graphics2D g, MDCView v) {
        boolean result;
        BufferedImage img = this.cache.get(v.getModel());
        boolean bl = result = img != null;
        if (result) {
            AffineTransform t = g.getTransform();
            if (this.temporaryTransform == null) {
                this.temporaryTransform = new AffineTransform();
            }
            this.temporaryTransform.setToTranslation(t.getTranslateX(), t.getTranslateY());
            g.setTransform(this.temporaryTransform);
            g.drawImage((Image)img, -1, -1, null);
            g.setTransform(t);
        }
        return result;
    }

    private void drawSelection(Graphics2D g, int i, MDCView v) {
        if (this.cursor != null && this.cursor.hasMark()) {
            int a = Math.min(this.cursor.getInsert().getIndex(), this.cursor.getMark().getIndex());
            int b = Math.max(this.cursor.getInsert().getIndex(), this.cursor.getMark().getIndex());
            if (a <= i && i < b) {
                float w = v.getWidth();
                float h = v.getHeight();
                if (this.drawingSpecifications.getTextOrientation().isHorizontal()) {
                    if (v.nextIsHorizontallyAdjacent()) {
                        w += this.drawingSpecifications.getSmallSkip();
                    }
                } else {
                    h += this.drawingSpecifications.getSmallSkip();
                }
                g.setColor(new Color(0, 0, 255, 50));
                g.fill(new Rectangle2D.Double(0.0, 0.0, w, h));
            }
        }
    }

    private boolean drawView(Graphics2D g, MDCView v, int depth) {
        return this.drawView(g, v, 0, v.getNumberOfSubviews(), depth);
    }

    private boolean drawView(Graphics2D g, MDCView v, int startPos, int endPos, int depth) {
        Graphics2D currentG = g;
        BufferedImage img = null;
        Color oldBackground = g.getBackground();
        if (depth == 1 && v.getModel() instanceof TopItem) {
            if (this.clip) {
                this.temporaryRectangle = g.getClipBounds(this.temporaryRectangle);
                if (this.temporaryRectangle != null && ((double)v.getHeight() < this.temporaryRectangle.getMinY() || 0.0 > this.temporaryRectangle.getMaxY()) || 0.0 > this.temporaryRectangle.getMaxX() || (double)v.getWidth() < this.temporaryRectangle.getMinX()) {
                    return false;
                }
            }
            if (this.isCached() && this.drawFromCache(g, v)) {
                this.testAndDrawCursor(g, v);
                return true;
            }
            if (this.isCached()) {
                Point2D.Float o = new Point2D.Float();
                Point2D.Float p = new Point2D.Float();
                currentG.getTransform().transform(new Point2D.Float(0.0f, 0.0f), o);
                currentG.getTransform().transform(new Point2D.Float(v.getWidth(), v.getHeight()), p);
                int x = (int)Math.ceil(((Point2D)p).getX() - ((Point2D)o).getX());
                int y = (int)Math.ceil(((Point2D)p).getY() - ((Point2D)o).getY());
                if (x > 0 && y > 0 && (img = this.cache.createImage(x + 2, y + 2)) != null) {
                    currentG = img.createGraphics();
                    currentG.setRenderingHints(g.getRenderingHints());
                    currentG.setBackground(new Color(255, 255, 255, 0));
                    currentG.clearRect(0, 0, img.getWidth(), img.getHeight());
                    currentG.translate(1, 1);
                    currentG.scale(g.getTransform().getScaleX(), g.getTransform().getScaleY());
                }
            }
            TopItem topItem = (TopItem)v.getModel();
            this.elementDrawer.setDrawingState(topItem.getState());
            if (topItem.getState().isShaded()) {
                g.setBackground(this.drawingSpecifications.getGrayColor());
                this.shadeView(currentG, v);
            }
        }
        if (this.elementDrawer.getDrawingState().isRed()) {
            currentG.setColor(this.drawingSpecifications.getRedColor());
        } else {
            currentG.setColor(this.drawingSpecifications.getBlackColor());
        }
        Graphics2D tmpG = (Graphics2D)currentG.create();
        tmpG.transform(v.getAffineTransform());
        this.elementDrawer.drawElement(v, tmpG, false);
        if (v.getNumberOfSubviews() != 0) {
            Point2D.Float ref = new Point2D.Float(0.0f, 0.0f);
            int end = endPos < v.getNumberOfSubviews() ? endPos : v.getNumberOfSubviews();
            for (int i = startPos; i < endPos && i < end; ++i) {
                double subvy;
                double subvx;
                MDCView subv = v.getSubView(i);
                Graphics2D subViewG = tmpG;
                if (v.getDirection().isLeftToRight()) {
                    subvx = subv.getPosition().x;
                    subvy = subv.getPosition().y;
                } else {
                    subvx = (double)v.getInternalWidth() - subv.getPosition().x - (double)subv.getWidth();
                    subvy = subv.getPosition().y;
                }
                subViewG.translate(subvx, subvy);
                boolean wasDrawn = this.drawView(subViewG, subv, depth + 1);
                if (wasDrawn && v.getModel() instanceof TopItemList) {
                    this.drawSelection(tmpG, i, subv);
                }
                subViewG.translate(-subvx, -subvy);
            }
        }
        this.elementDrawer.drawElement(v, tmpG, true);
        tmpG.dispose();
        if (img != null) {
            this.cache.put(v.getModel(), img);
            this.drawFromCache(g, v);
        }
        this.testAndDrawCursor(g, v);
        if (img != null) {
            currentG.dispose();
        }
        if (g.getBackground() != oldBackground) {
            g.setBackground(oldBackground);
        }
        if (this.debug) {
            this.drawDebug(g, v);
        }
        return true;
    }

    public void DrawViewAndCursor(Graphics2D g2d, MDCView view, MDCCaret cursor, DrawingSpecifications ds) {
        this.drawingSpecifications = ds;
        this.elementDrawer.prepareDrawing(this.drawingSpecifications);
        this.cursor = cursor;
        this.drawView(g2d, view, 0);
        this.cursor = null;
        this.elementDrawer.cleanup();
    }

    public void DrawViewAndCursor(Graphics2D g2d, MDCView view, MDCCaret cursor, DrawingSpecifications ds, MDCPosition start, MDCPosition end) {
        this.drawingSpecifications = ds;
        this.elementDrawer.prepareDrawing(this.drawingSpecifications);
        this.cursor = cursor;
        this.drawView(g2d, view, 0, start.getIndex(), end.getIndex());
        this.cursor = null;
        this.elementDrawer.cleanup();
    }

    public void flushCache() {
        if (this.isCached()) {
            this.cache.reset();
        }
    }

    public Point2D getPointForPosition(MDCView v, MDCPosition position) {
        Point2D ref;
        if (position.getIndex() == 0) {
            ref = new Point2D.Float(0.0f, 0.0f);
        } else if (position.getIndex() < v.getNumberOfSubviews()) {
            MDCView subv = v.getSubView(position.getIndex());
            ref = new Point2D.Double(subv.getPosition().x, subv.getPosition().y);
        } else {
            MDCView subv = v.getSubView(v.getNumberOfSubviews() - 1);
            ref = new Point2D.Double(subv.getPosition().x + (double)subv.getWidth(), subv.getPosition().y);
        }
        return ref;
    }

    public MDCPosition getPositionForPoint(MDCView v, Point clickPoint, DrawingSpecifications ds) {
        int pos = -1;
        if (v.getNumberOfSubviews() != 0) {
            Point2D.Float point = new Point2D.Float();
            try {
                v.getAffineTransform().inverseTransform(new Point2D.Float(clickPoint.x, clickPoint.y), point);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
            for (int i = 0; pos == -1 && i < v.getNumberOfSubviews(); ++i) {
                MDCView subv = v.getSubView(i);
                double x = subv.getPosition().x;
                if (v.getDirection().equals(TextDirection.RIGHT_TO_LEFT)) {
                    x = (double)v.getInternalWidth() - x - (double)subv.getWidth();
                }
                double y = subv.getPosition().y;
                if ((double)point.x >= x && (double)point.y >= y && (double)point.x < x + (double)subv.getWidth() + (double)ds.getSmallSkip() && (double)point.y < y + (double)subv.getHeight() + (double)ds.getSmallSkip()) {
                    if (ds.getTextOrientation().isHorizontal()) {
                        if ((double)point.x < x + (double)(subv.getWidth() / 2.0f)) {
                            if (ds.getTextDirection().isLeftToRight()) {
                                pos = i;
                                continue;
                            }
                            pos = i + 1;
                            continue;
                        }
                        if (ds.getTextDirection().isLeftToRight()) {
                            pos = i + 1;
                            continue;
                        }
                        pos = i;
                        continue;
                    }
                    if ((double)point.y < y + (double)(subv.getHeight() / 2.0f)) {
                        pos = i;
                        continue;
                    }
                    pos = i + 1;
                    continue;
                }
                if (ds.getTextOrientation().isHorizontal()) {
                    if (!(y > (double)point.y)) continue;
                    pos = i > 0 ? i - 1 : 0;
                    continue;
                }
                if (ds.getTextDirection().isLeftToRight()) {
                    if (!(x > (double)point.x)) continue;
                    pos = i;
                    continue;
                }
                if (!(x + (double)ds.getMaxCadratWidth() < (double)point.x)) continue;
                pos = i;
            }
        }
        if (pos == -1) {
            return new MDCPosition((TopItemList)v.getModel(), v.getModel().getNumberOfChildren());
        }
        return new MDCPosition((TopItemList)v.getModel(), pos);
    }

    public Rectangle2D getRectangleAroundPosition(MDCView v, MDCPosition position, DrawingSpecifications specs) {
        int index = position.getIndex();
        Rectangle2D result = new Rectangle2D.Float(0.0f, 0.0f, this.drawingSpecifications.getSmallSkip(), this.drawingSpecifications.getMaxCadratHeight());
        if (v.getNumberOfSubviews() != 0) {
            boolean previousIsBreak = false;
            boolean nextIsBreak = false;
            Rectangle2D previousRectangle = new Rectangle2D.Float(0.0f, 0.0f, this.drawingSpecifications.getSmallSkip(), this.drawingSpecifications.getMaxCadratHeight());
            Rectangle2D nextRectangle = new Rectangle2D.Float(0.0f, v.getHeight() - this.drawingSpecifications.getMaxCadratHeight(), this.drawingSpecifications.getSmallSkip(), this.drawingSpecifications.getMaxCadratHeight());
            if (index > 0) {
                previousRectangle = new Rectangle2D.Double(v.getSubView((int)(index - 1)).getPosition().x + (double)v.getSubView(index - 1).getWidth(), v.getSubView((int)(index - 1)).getPosition().y, 1.0, v.getSubView(index - 1).getHeight());
            }
            if (index < v.getNumberOfSubviews()) {
                nextRectangle = new Rectangle2D.Double(v.getSubView((int)index).getPosition().x, v.getSubView((int)index).getPosition().y, 1.0, v.getSubView(index).getHeight());
            }
            if (index <= 0 || v.getSubView(index - 1) == null || v.getSubView(index - 1).getModel().isBreak()) {
                previousIsBreak = true;
            }
            if (index >= v.getNumberOfSubviews() || v.getSubView(index) == null || v.getSubView(index).getModel().isBreak()) {
                nextIsBreak = true;
            }
            if (previousIsBreak) {
                result = nextRectangle;
            } else if (nextIsBreak) {
                result = previousRectangle;
            } else {
                result = previousRectangle;
                result.add(nextRectangle);
            }
        }
        if (v.getDirection().equals(TextDirection.RIGHT_TO_LEFT)) {
            double x = result.getMinX();
            double y = result.getMinY();
            double w = result.getWidth();
            double h = result.getHeight();
            x = (double)v.getInternalWidth() - x - w;
            result = new Rectangle2D.Double(x, y, w, h);
        }
        return result;
    }

    public boolean isCached() {
        return this.cache != null;
    }

    public boolean isClip() {
        return this.clip;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isPaged() {
        return this.elementDrawer.isPaged();
    }

    public boolean isShadeAfter() {
        return this.elementDrawer.isShadeAfter();
    }

    public void setCached(boolean c) {
        this.cache = c ? new PictureCache(1000) : null;
    }

    public void setClip(boolean clip) {
        this.clip = clip;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public void setPaged(boolean paged) {
        this.elementDrawer.setPaged(paged);
    }

    public void setShadeAfter(boolean shadeAfter) {
        this.elementDrawer.setShadeAfter(shadeAfter);
    }

    private void shadeView(Graphics2D g, MDCView v) {
        Paint oldPaint = g.getPaint();
        g.setPaint(this.drawingSpecifications.getGrayColor());
        g.fill(new Rectangle2D.Float(0.0f, 0.0f, v.getWidth(), v.getHeight()));
        if (this.drawingSpecifications.getTextOrientation().isHorizontal() && v.nextIsHorizontallyAdjacent()) {
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.x = v.getWidth();
            rect.y = 0.0;
            rect.height = v.getHeight();
            rect.width = (float)(v.getNext().getPosition().x - (v.getPosition().x + (double)v.getWidth()));
            g.fill(rect);
        }
        g.setPaint(oldPaint);
    }

    private void testAndDrawCursor(Graphics2D g, MDCView v) {
        TextDirection textDirection = this.drawingSpecifications.getTextDirection();
        TextOrientation textOrientation = this.drawingSpecifications.getTextOrientation();
        if (this.cursor != null && this.cursor.getInsert() != null) {
            boolean drawAfterView = false;
            boolean drawBeforeView = false;
            drawBeforeView = v.getModel() == this.cursor.getInsert().getPosition().getElementAfter();
            boolean bl = drawAfterView = v.getModel() == this.cursor.getInsert().getPosition().getElementBefore();
            if (drawBeforeView && v.getModel() != null && v.getModel().isBreak() && v.getPrevious() != null && v.getPrevious().getModel() != null && !v.getPrevious().getModel().isBreak()) {
                drawBeforeView = false;
            }
            if (drawAfterView && v.getModel().isBreak()) {
                drawAfterView = false;
            }
            if (drawAfterView || drawBeforeView) {
                Color currentColor = g.getColor();
                g.setColor(this.drawingSpecifications.getCursorColor());
                g.setStroke(this.drawingSpecifications.getWideStroke());
                if (drawAfterView) {
                    if (textOrientation.isHorizontal()) {
                        if (textDirection.isLeftToRight()) {
                            g.draw(new Line2D.Double(v.getWidth(), 0.0, v.getWidth(), this.drawingSpecifications.getMaxCadratHeight()));
                        } else {
                            g.draw(new Line2D.Double(0.0, 0.0, 0.0, this.drawingSpecifications.getMaxCadratHeight()));
                        }
                    } else {
                        g.draw(new Line2D.Double(0.0, v.getHeight(), this.drawingSpecifications.getMaxCadratWidth(), v.getHeight()));
                    }
                } else if (drawBeforeView) {
                    if (textOrientation.isHorizontal()) {
                        if (textDirection.isLeftToRight()) {
                            g.draw(new Line2D.Double(0.0, 0.0, 0.0, this.drawingSpecifications.getMaxCadratHeight()));
                        } else {
                            g.draw(new Line2D.Double(v.getWidth(), 0.0, v.getWidth(), this.drawingSpecifications.getMaxCadratHeight()));
                        }
                    } else {
                        g.draw(new Line2D.Double(0.0, 0.0, this.drawingSpecifications.getMaxCadratWidth(), 0.0));
                    }
                }
                g.setColor(currentColor);
            }
        }
    }
}

