/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.draw;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.draw.PagedViewBuilder;
import jsesh.mdcDisplayer.draw.ViewDrawer;
import jsesh.mdcDisplayer.layout.MDCPagedEditorKit;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;

public class ViewPrinter
implements Pageable,
Printable {
    private TopItemList model;
    private ViewDrawer drawer;
    private PagedViewBuilder builder;
    private MDCView currentView = null;
    private DrawingSpecifications drawingSpecifications;
    private PageFormat pageformat;

    public ViewPrinter() {
        MDCPagedEditorKit kit = MDCPagedEditorKit.getDefaultMDCPagedEditorKit();
        this.pageformat = null;
        this.drawer = new ViewDrawer();
        this.drawer.setPaged(true);
        this.builder = new PagedViewBuilder();
        this.model = null;
        this.drawingSpecifications = new DrawingSpecifications();
    }

    public int getNumberOfPages() {
        return this.getView().getNumberOfSubviews();
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        MDCView v;
        if (this.pageformat == null && (v = this.getPageView(pageIndex)) != null) {
            PageFormat format = new PageFormat();
            format.getPaper().setSize(v.getWidth(), v.getHeight());
            format.getPaper().setImageableArea(0.0, 0.0, v.getWidth(), v.getHeight());
            return format;
        }
        return this.pageformat;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("bad page index " + pageIndex);
        }
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.builder.getPagedLayout().setPageFormat(pageFormat);
        MDCView pageView = this.getPageView(pageIndex);
        if (pageView == null) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        this.drawer.draw((Graphics2D)graphics, pageView, this.getDrawingSpecifications());
        return 0;
    }

    private MDCView getView() {
        if (this.currentView == null) {
            this.currentView = this.builder.buildView(this.model, this.getDrawingSpecifications());
        }
        return this.currentView;
    }

    private MDCView getPageView(int pageIndex) {
        MDCView view = this.getView();
        if (pageIndex >= this.getNumberOfPages()) {
            this.currentView = null;
            return null;
        }
        return view.getSubView(pageIndex);
    }

    public DrawingSpecifications getDrawingSpecifications() {
        return this.drawingSpecifications;
    }

    public TopItemList getModel() {
        return this.model;
    }

    public PageFormat getPageformat() {
        return this.pageformat;
    }

    public void setDrawingSpecifications(DrawingSpecifications specification) {
        this.drawingSpecifications = this.drawingSpecifications;
    }

    public void setModel(TopItemList list) {
        this.model = list;
    }

    public void setPageformat(PageFormat format) {
        this.pageformat = format;
        this.builder.getPagedLayout().setPageFormat(this.pageformat);
    }
}

