/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.layout;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jsesh.bzr.simple.ShapeChar;

public class ComplexLigatureLayout {
    ShapeChar signShape;
    Area signArea;
    Rectangle2D[] zones = new Rectangle2D[3];
    static final double MARGIN = 1.0;
    static final double MAXHEIGHT = 18.0;

    public ComplexLigatureLayout(ShapeChar signShape) {
        this.signShape = signShape;
        this.signArea = signShape.getSignArea(0.0, 0.0, 1.0, 1.0, 0.0);
    }

    private void computeThirdArea() {
        Point2D.Double inner;
        double signHeight = this.signShape.getBbox().getHeight();
        double signWidth = this.signShape.getBbox().getWidth();
        Point2D.Double outer = new Point2D.Double(signWidth / 2.0, signHeight);
        double t = this.findBestZonePosition(outer, inner = new Point2D.Double(signWidth, 0.0), -signWidth, signHeight);
        if (t > 0.2) {
            Point2D.Double p = this.computePosition(outer, inner, t);
            this.zones[2] = new Rectangle2D.Double(0.0, p.y, p.x, signHeight);
        } else {
            outer.x = 0.0;
            t = this.findBestZonePosition(outer, inner, -signWidth, signHeight);
            if (t > 0.2) {
                Point2D.Double p = this.computePosition(outer, inner, t);
                this.zones[2] = new Rectangle2D.Double(0.0, p.y, p.x, signHeight);
            }
            this.zones[2] = null;
        }
    }

    private Point2D.Double computePosition(Point2D.Double outer, Point2D.Double inner, double t) {
        double x = outer.x + t * (inner.x - outer.x);
        double y = outer.y + t * (inner.y - outer.y);
        return new Point2D.Double(x, y);
    }

    private void computeFirstArea() {
        Point2D.Double inner;
        double y = 0.5 * this.signShape.getBbox().getHeight();
        double height = this.signShape.getBbox().getHeight() / 3.0;
        double width = this.signShape.getBbox().getWidth() / 2.0;
        Point2D.Double outer = new Point2D.Double(-width, y);
        double t = this.findBestZonePosition(outer, inner = new Point2D.Double(0.0, y), width, height);
        if (t < 0.2) {
            height = this.signShape.getBbox().getHeight() / 4.0;
            width = this.signShape.getBbox().getWidth() / 4.0;
            t = this.findBestZonePosition(outer, inner, width, height);
            if (t < 0.1) {
                this.zones[0] = null;
            } else {
                Point2D.Double p = this.computePosition(outer, inner, t);
                this.zones[0] = new Rectangle2D.Double(p.x, p.y, width, height);
            }
        } else {
            Point2D.Double p = this.computePosition(outer, inner, t);
            this.zones[0] = new Rectangle2D.Double(p.x, p.y, width, height);
        }
    }

    private double findBestZonePosition(Point2D.Double outer, Point2D.Double inner, double width, double height) {
        double innerT = 1.0;
        double outerT = 0.0;
        while (Math.abs(innerT - outerT) > 0.01) {
            double middleT = (innerT + outerT) / 2.0;
            Point2D.Double p = this.computePosition(outer, inner, middleT);
            double minx = p.x - 1.0;
            double miny = p.y - 1.0;
            if (width < 0.0) {
                minx += width;
            }
            if (height < 0.0) {
                miny += height;
            }
            Area intersectArea = new Area(new Rectangle2D.Double(minx, miny, Math.abs(width) + 2.0, Math.abs(height) + 2.0));
            intersectArea.intersect(this.signArea);
            if (intersectArea.isEmpty()) {
                outerT = middleT;
                continue;
            }
            innerT = middleT;
        }
        return outerT;
    }

    private void computeSecondArea() {
        Point2D.Double inner;
        double width = this.signShape.getBbox().getWidth() / 2.0;
        double height = this.signShape.getBbox().getHeight() / 2.5;
        Point2D.Double outer = new Point2D.Double(this.signShape.getBbox().getWidth(), 0.0);
        double t = this.findBestZonePosition(outer, inner = new Point2D.Double(this.signShape.getBbox().getWidth() / 2.0, 0.0), width, height);
        if (t < 0.2) {
            height = this.signShape.getBbox().getHeight() / 3.0;
            t = this.findBestZonePosition(outer, inner, width, height);
            if (t < 0.1) {
                this.zones[1] = null;
            } else {
                Point2D.Double p = this.computePosition(outer, inner, t);
                this.zones[1] = new Rectangle2D.Double(p.x, p.y, width, height);
            }
        } else {
            Point2D.Double p = this.computePosition(outer, inner, t);
            this.zones[1] = new Rectangle2D.Double(p.x, p.y, width, height);
        }
    }

    public Rectangle2D getLigatureArea(int i) {
        switch (i) {
            case 0: {
                this.computeFirstArea();
                break;
            }
            case 1: {
                this.computeSecondArea();
                break;
            }
            case 2: {
                this.computeThirdArea();
                break;
            }
        }
        return this.zones[i];
    }
}

