/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.layout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jsesh.mdcDisplayer.mdcView.MDCView;

public class Zone {
    private Point2D.Double currentPoint = new Point2D.Double();
    private Rectangle2D zoneArea;
    private ArrayList views;

    public Zone(double minWidth, double minHeight) {
        this.zoneArea = new Rectangle2D.Double(0.0, 0.0, minWidth, minHeight);
        this.views = new ArrayList();
    }

    public void add(MDCView view) {
        view.getPosition().setLocation(this.currentPoint.x + view.getDeltaBaseX(), this.currentPoint.y + view.getDeltaBaseY());
        this.zoneArea.add(new Rectangle2D.Double(view.getPosition().x, view.getPosition().y, view.getWidth(), view.getHeight()));
        this.views.add(view);
    }

    public double getWidth() {
        return this.zoneArea.getWidth();
    }

    public double getHeight() {
        return this.zoneArea.getHeight();
    }

    public boolean isEmpty() {
        return this.zoneArea.isEmpty();
    }

    public double getMinY() {
        return this.zoneArea.getMinY();
    }

    public double getMinX() {
        return this.zoneArea.getMinX();
    }

    public double getMaxX() {
        return this.zoneArea.getMaxX();
    }

    public Point2D getCurrentPoint() {
        return this.currentPoint;
    }

    public void moveCurrentPoint(double dx, double dy) {
        this.currentPoint.setLocation(this.currentPoint.x + dx, this.currentPoint.y + dy);
    }

    public void translateBy(Point2D zoneStart) {
        for (int i = 0; i < this.views.size(); ++i) {
            MDCView v = (MDCView)this.views.get(i);
            v.getPosition().x += zoneStart.getX();
            v.getPosition().y += zoneStart.getY();
        }
    }
}

