/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.preferences;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.constants.TextOrientation;
import jsesh.mdcDisplayer.draw.HieroglyphsDrawer;
import jsesh.mdcDisplayer.draw.SimpleHieroglyphicDrawer;
import jsesh.resources.ResourcesManager;
import jsesh.utils.DoubleDimensions;

public class DrawingSpecifications
implements Cloneable {
    private float baseLength = -1.0f;
    private float cadratWidth = 16.0f;
    private float cartoucheknotLength = 2.0f;
    private float cartoucheLineWidth = 2.0f;
    private float cartoucheLoopLength = 10.0f;
    private float cartoucheMargin = 2.0f;
    private Color cursorColor;
    private float enclosureBastionDepth = 5.0f;
    private float enclosureBastionLength = 10.0f;
    private float enclosureBastionSkip = 5.0f;
    private Font[] fontMap;
    private FontRenderContext fontRenderContext;
    private HieroglyphsDrawer hieroglyphsDrawer;
    private float hutSmallMargin = 3.0f;
    private float hutSquareSize = 10.0f;
    private float leftMargin;
    private float lineSkip = 6.0f;
    private float columnSkip = 10.0f;
    private float maxCadratHeight = 18.0f;
    private float maxCadratWidth = 22.0f;
    private float pageWidth = 1120.0f;
    private float serekhDoorSize = 20.0f;
    private boolean smallSignsCentered = false;
    private float smallSkip = 2.0f;
    private Font superScriptFont;
    private TextDirection textDirection;
    private TextOrientation textOrientation;
    private float topMargin;
    private PageFormat pageFormat;
    private float fineLineWidth = 0.5f;
    private float wideLineWidth = 3.0f;
    private Color backgroundColor = Color.WHITE;

    public DrawingSpecifications() {
        this.fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        this.textOrientation = TextOrientation.HORIZONTAL;
        this.textDirection = TextDirection.LEFT_TO_RIGHT;
        this.hieroglyphsDrawer = new SimpleHieroglyphicDrawer();
        this.topMargin = this.smallSkip + this.getCartoucheLineWidth() + this.getCartoucheMargin();
        this.leftMargin = 3.0f * this.smallSkip;
        this.buildFontMap();
        this.superScriptFont = new Font(null, 0, 5);
        this.cursorColor = new Color(0, 0, 255, 100);
        this.pageFormat = null;
    }

    private void buildFontMap() {
        this.fontMap = new Font[256];
        this.fontMap[108] = new Font("Serif", 0, 12);
        this.fontMap[98] = new Font("Serif", 1, 12);
        this.fontMap[105] = new Font("Serif", 2, 12);
        this.fontMap[116] = ResourcesManager.getInstance().getTransliterationFont();
    }

    public Object clone() throws CloneNotSupportedException {
        DrawingSpecifications result = (DrawingSpecifications)super.clone();
        result.buildFontMap();
        return result;
    }

    public float computeCartouchePartLength(int type, int element) {
        float result = 0.0f;
        block0 : switch (type) {
            case 99: {
                switch (element) {
                    case 0: {
                        result = 0.0f;
                        break block0;
                    }
                    case 1: {
                        result = this.getCartoucheLoopLength();
                        break block0;
                    }
                    case 2: {
                        result = this.getCartoucheLoopLength() + this.getCartoucheknotLength();
                        break block0;
                    }
                }
                throw new RuntimeException("bad value for element " + element);
            }
            case 115: {
                switch (element) {
                    case 1: {
                        result = this.getHutSmallMargin() + this.getCartoucheLineWidth();
                        break;
                    }
                    case 2: {
                        result = this.getHutSmallMargin() + this.getCartoucheLineWidth() + this.getSerekhDoorSize();
                    }
                }
                break;
            }
            case 104: {
                switch (element) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        result = this.getHutSmallMargin() + this.getCartoucheLineWidth();
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        result = this.getHutSmallMargin() + this.getCartoucheLineWidth() + this.getHutSquareSize();
                        break block0;
                    }
                }
                throw new RuntimeException("bad value for element " + element);
            }
            case 102: {
                if (element == 0) break;
                result = this.getHutSmallMargin() + this.getEnclosureBastionDepth() + this.getCartoucheLineWidth();
            }
        }
        return result;
    }

    public float computeCartoucheSecondaryLength(int type) {
        float result = 0.0f;
        switch (type) {
            case 99: 
            case 104: 
            case 115: {
                result = this.getCartoucheMargin() + this.getCartoucheLineWidth();
                break;
            }
            case 102: {
                result = this.getCartoucheMargin() + this.getCartoucheLineWidth() + this.getEnclosureBastionDepth();
            }
        }
        return result;
    }

    public DrawingSpecifications copy() {
        try {
            return (DrawingSpecifications)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public float getBaseLength() {
        if (this.baseLength == -1.0f) {
            Rectangle2D r = this.hieroglyphsDrawer.getBBox("A1");
            this.baseLength = (float)r.getHeight();
        }
        return this.baseLength;
    }

    public Color getBlackColor() {
        return Color.BLACK;
    }

    public float getCadratWidth() {
        return this.cadratWidth;
    }

    public float getCartoucheknotLength() {
        return this.cartoucheknotLength;
    }

    public float getCartoucheLineWidth() {
        return this.cartoucheLineWidth;
    }

    public float getCartoucheLoopLength() {
        return this.cartoucheLoopLength;
    }

    public float getCartoucheMargin() {
        return this.cartoucheMargin;
    }

    public Stroke buildCartoucheStroke(int cartoucheType) {
        return new BasicStroke(this.getCartoucheLineWidth());
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public float getEnclosureBastionDepth() {
        return this.enclosureBastionDepth;
    }

    public float getEnclosureBastionLength() {
        return this.enclosureBastionLength;
    }

    public float getEnclosureBastionSkip() {
        return this.enclosureBastionSkip;
    }

    public Stroke getFineStroke() {
        return new BasicStroke(this.fineLineWidth);
    }

    public Font getFont(char code) {
        Font result;
        if (code < '\u0000' || code > '\u00ff') {
            code = (char)108;
        }
        if ((result = this.fontMap[code]) == null) {
            result = this.fontMap[108];
        }
        return result;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public Color getGrayColor() {
        Color gray = new Color(0.5f, 0.5f, 0.5f, 0.5f);
        return gray;
    }

    public HieroglyphsDrawer getHieroglyphsDrawer() {
        return this.hieroglyphsDrawer;
    }

    public float getHutSmallMargin() {
        return this.hutSmallMargin;
    }

    public float getHutSquareSize() {
        return this.hutSquareSize;
    }

    public float getLeftMargin() {
        return this.leftMargin;
    }

    public float getLineSkip() {
        return this.lineSkip;
    }

    public float getMaxCadratHeight() {
        return this.maxCadratHeight;
    }

    public float getMaxCadratWidth() {
        return this.maxCadratWidth;
    }

    public float getPageWidth() {
        return this.pageWidth;
    }

    public float getPhilologyWidth(int philologyType) {
        if (philologyType >= 100) {
            philologyType /= 2;
        }
        float width = 0.0f;
        switch (philologyType) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                width = 4.0f;
            }
        }
        return width;
    }

    public Color getRedColor() {
        return Color.RED;
    }

    public float getSerekhDoorSize() {
        return this.serekhDoorSize;
    }

    public float getSmallSkip() {
        return this.smallSkip;
    }

    public Dimension2D getSuperScriptDimensions(String text) {
        Rectangle2D r = this.superScriptFont.getStringBounds(text.toString(), this.fontRenderContext);
        return new DoubleDimensions(r.getWidth(), r.getHeight());
    }

    public Font getSuperScriptFont() {
        return this.superScriptFont;
    }

    public Rectangle2D getTextDimensions(char scriptCode, String text) {
        Rectangle2D r = this.getFont(scriptCode).getStringBounds(text.toString(), this.fontRenderContext);
        return r;
    }

    public TextDirection getTextDirection() {
        return this.textDirection;
    }

    public TextOrientation getTextOrientation() {
        return this.textOrientation;
    }

    public float getTopMargin() {
        return this.topMargin;
    }

    public Stroke getWideStroke() {
        return new BasicStroke(this.wideLineWidth);
    }

    public boolean isSmallSignsCentered() {
        return this.smallSignsCentered;
    }

    public void setBaseLength(float baseLength) {
        this.baseLength = baseLength;
    }

    public void setCadratWidth(float f) {
        this.cadratWidth = f;
    }

    public void setCartoucheknotLength(float cartoucheknotLength) {
        this.cartoucheknotLength = cartoucheknotLength;
    }

    public void setCartoucheLineWidth(float cartoucheLineWidth) {
        this.cartoucheLineWidth = cartoucheLineWidth;
    }

    public void setCartoucheLoopLength(float cartoucheLoopLength) {
        this.cartoucheLoopLength = cartoucheLoopLength;
    }

    public void setCartoucheMargin(float cartoucheMargin) {
        this.cartoucheMargin = cartoucheMargin;
    }

    public void setEnclosureBastionDepth(float enclosureBastionDepth) {
        this.enclosureBastionDepth = enclosureBastionDepth;
    }

    public void setEnclosureBastionLength(float enclosureBastionLength) {
        this.enclosureBastionLength = enclosureBastionLength;
    }

    public void setEnclosureBastionSkip(float enclosureBastionSkip) {
        this.enclosureBastionSkip = enclosureBastionSkip;
    }

    public void setFontRenderContext(FontRenderContext context) {
        this.fontRenderContext = context;
    }

    public void setHieroglyphsDrawer(HieroglyphsDrawer drawer) {
        this.hieroglyphsDrawer = drawer;
    }

    public void setHutSmallMargin(float hutSmallMargin) {
        this.hutSmallMargin = hutSmallMargin;
    }

    public void setHutSquareSize(float hutSquareSize) {
        this.hutSquareSize = hutSquareSize;
    }

    public void setLeftMargin(float leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setLineSkip(float f) {
        this.lineSkip = f;
    }

    public void setMaxCadratHeight(float f) {
        this.maxCadratHeight = f;
    }

    public void setMaxCadratWidth(float maxCadratWidth) {
        this.maxCadratWidth = maxCadratWidth;
    }

    public void setPageWidth(float f) {
        this.pageWidth = f;
    }

    public void setSerekhDoorSize(float serekhDoorSize) {
        this.serekhDoorSize = serekhDoorSize;
    }

    public void setSmallSignsCentered(boolean b) {
        this.smallSignsCentered = b;
    }

    public void setSmallSkip(float f) {
        this.smallSkip = f;
    }

    public void setTextDirection(TextDirection textDirection) {
        this.textDirection = textDirection;
    }

    public void setTextOrientation(TextOrientation i) {
        this.textOrientation = i;
    }

    public void setTopMargin(float topMargin) {
        this.topMargin = topMargin;
    }

    public float getColumnSkip() {
        return this.columnSkip;
    }

    public void setColumnSkip(float columnSkip) {
        this.columnSkip = columnSkip;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public float getFineLineWidth() {
        return this.fineLineWidth;
    }

    public void setFineLineWidth(float fineLineWidth) {
        this.fineLineWidth = fineLineWidth;
    }

    public float getWideLineWidth() {
        return this.wideLineWidth;
    }

    public void setWideLineWidth(float wideLineWidth) {
        this.wideLineWidth = wideLineWidth;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

