/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class BackgroundBorder
implements Border {
    private final BufferedImage image;

    public BackgroundBorder(BufferedImage image) {
        this.image = image;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        ((Graphics2D)g).drawRenderedImage(this.image, AffineTransform.getTranslateInstance(x += (width - this.image.getWidth()) / 2, y += (height - this.image.getHeight()) / 2));
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, 0, 0);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public static void main(String[] args) throws IOException {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JTextArea area = new JTextArea();
        area.setForeground(Color.GREEN);
        area.setOpaque(false);
        area.read(new StringReader("CentredBackgroundBorder.java"), null);
        String url = "file:/home/rosmord/Images/pap.png";
        JScrollPane sp = new JScrollPane(area);
        sp.getViewport().setOpaque(false);
        sp.setViewportBorder(new BackgroundBorder(ImageIO.read(new URL(url))));
        JFrame f = new JFrame("BackgroundBorderExample");
        f.getContentPane().add(sp);
        f.setDefaultCloseOperation(3);
        f.setSize(600, 400);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

