/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.editor;

import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.constants.TextOrientation;
import jsesh.mdcDisplayer.swing.editor.JMDCEditor;
import jsesh.mdcDisplayer.swing.editor.SelectOrientationAction;
import jsesh.mdcDisplayer.swing.editor.SelectTextDirectionAction;
import jsesh.mdcDisplayer.swing.editor.actions.CopyAction;
import jsesh.mdcDisplayer.swing.editor.actions.CutAction;
import jsesh.mdcDisplayer.swing.editor.actions.ExpandSelectionAction;
import jsesh.mdcDisplayer.swing.editor.actions.GoDownAction;
import jsesh.mdcDisplayer.swing.editor.actions.GoLeftAction;
import jsesh.mdcDisplayer.swing.editor.actions.GoRightAction;
import jsesh.mdcDisplayer.swing.editor.actions.GoUpAction;
import jsesh.mdcDisplayer.swing.editor.actions.GroupHorizontalAction;
import jsesh.mdcDisplayer.swing.editor.actions.GroupVerticalAction;
import jsesh.mdcDisplayer.swing.editor.actions.NewLineAction;
import jsesh.mdcDisplayer.swing.editor.actions.NewPageAction;
import jsesh.mdcDisplayer.swing.editor.actions.PasteAction;
import jsesh.utils.PlatformDetection;

public class MDCEditorKeyManager
extends KeyAdapter {
    public static final String GO_LEFT = "GO LEFT";
    public static final String GO_RIGHT = "GO RIGHT";
    public static final String INSERT_CHAR = "INSERT CHAR";
    public static final String BEGINNING_OF_LINE = "BEGINNING OF LINE";
    public static final String END_OF_LINE = "END_OF_LINE";
    public static final String COPY = "COPY";
    public static final String PASTE = "PASTE";
    public static final String CUT = "CUT";
    public static final String GROUP_HORIZONTAL = "GROUP HORIZONTAL";
    public static final String GROUP_VERTICAL = "GROUP VERTICAL";
    public static final String EXPAND_SELECTION_LEFT = "EXPAND_SELECTION_LEFT";
    public static final String EXPAND_SELECTION_RIGHT = "EXPAND_SELECTION_RIGHT";
    public static final String NEW_LINE = "NEW_LINE";
    public static final String NEW_PAGE = "NEW_PAGE";
    public static final String GO_DOWN = "GO DOWN";
    public static final String GO_UP = "GO UP";
    public static final String SELECT_HORIZONTAL_ORIENTATION = "SELECT_HORIZONTAL_ORIENTATION";
    public static final String SELECT_VERTICAL_ORIENTATION = "SELECT_VERTICAL_ORIENTATION";
    public static final String SELECT_L2R_DIRECTION = "SELECT_L2R_DIRECTION";
    public static final String SELECT_R2L_DIRECTION = "SELECT_R2L_DIRECTION";
    private static MDCEditorKeyManager instance = null;
    private String controlKey = PlatformDetection.getPlatform() == 1 ? "meta" : "control";
    private ActionMap actionMap;
    private InputMap inputMap = new InputMap();

    public static MDCEditorKeyManager getInstance() {
        if (instance == null) {
            instance = new MDCEditorKeyManager();
        }
        return instance;
    }

    private MDCEditorKeyManager() {
        this.actionMap = new ActionMap();
        this.addInputs();
        this.addActions();
    }

    private void addAction(String command, Action action) {
        this.actionMap.put(command, action);
    }

    private void addActions() {
        this.addAction(GO_RIGHT, new GoRightAction());
        this.addAction(GO_LEFT, new GoLeftAction());
        this.addAction(GO_DOWN, new GoDownAction());
        this.addAction(GO_UP, new GoUpAction());
        this.addAction(BEGINNING_OF_LINE, new AbstractAction("Beginning of line"){

            public void actionPerformed(ActionEvent e) {
                JMDCEditor ed = (JMDCEditor)e.getSource();
                ed.getWorkflow().cursorToBeginningOfLine();
            }
        });
        this.addAction(END_OF_LINE, new AbstractAction("End Of line"){

            public void actionPerformed(ActionEvent e) {
                JMDCEditor ed = (JMDCEditor)e.getSource();
                ed.getWorkflow().cursorToEndOfLine();
            }
        });
        this.addAction(NEW_LINE, new NewLineAction());
        this.addAction(NEW_PAGE, new NewPageAction());
        this.addAction(COPY, new CopyAction());
        this.addAction(PASTE, new PasteAction());
        this.addAction(CUT, new CutAction());
        this.addAction(GROUP_HORIZONTAL, new GroupHorizontalAction());
        this.addAction(GROUP_VERTICAL, new GroupVerticalAction());
        this.addAction(EXPAND_SELECTION_LEFT, new ExpandSelectionAction(-1));
        this.addAction(EXPAND_SELECTION_RIGHT, new ExpandSelectionAction(1));
        this.addAction(SELECT_HORIZONTAL_ORIENTATION, new SelectOrientationAction(TextOrientation.HORIZONTAL));
        this.addAction(SELECT_VERTICAL_ORIENTATION, new SelectOrientationAction(TextOrientation.VERTICAL));
        this.addAction(SELECT_L2R_DIRECTION, new SelectTextDirectionAction(TextDirection.LEFT_TO_RIGHT));
        this.addAction(SELECT_R2L_DIRECTION, new SelectTextDirectionAction(TextDirection.RIGHT_TO_LEFT));
    }

    private void addInput(String code, String command) {
        this.inputMap.put(KeyStroke.getKeyStroke(code), command);
    }

    private void addInputs() {
        this.addInput("LEFT", GO_LEFT);
        this.addInput("RIGHT", GO_RIGHT);
        this.addInput("DOWN", GO_DOWN);
        this.addInput("UP", GO_UP);
        this.addInput("HOME", BEGINNING_OF_LINE);
        this.addInput("END", END_OF_LINE);
        this.addInput("shift ENTER", NEW_PAGE);
        this.addInput("ENTER", NEW_LINE);
        this.addInput(this.controlKey + " C", COPY);
        this.addInput(this.controlKey + " X", CUT);
        this.addInput(this.controlKey + " V", PASTE);
        this.addInput(this.controlKey + " H", GROUP_HORIZONTAL);
        this.addInput(this.controlKey + " G", GROUP_VERTICAL);
        this.addInput("shift LEFT", EXPAND_SELECTION_LEFT);
        this.addInput("shift RIGHT", EXPAND_SELECTION_RIGHT);
    }

    public void control(JMDCEditor editor) {
        editor.addKeyListener(this);
        editor.setActionMap(this.actionMap);
        editor.setInputMap(0, this.inputMap);
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public InputMap getInputMap() {
        return this.inputMap;
    }

    public void keyTyped(KeyEvent e) {
        if (e.isActionKey() || e.isControlDown() || e.isMetaDown() || e.isAltDown()) {
            return;
        }
        if (e.getKeyChar() == '\n') {
            return;
        }
        if (e.getSource() instanceof JMDCEditor) {
            JMDCEditor editor = (JMDCEditor)e.getSource();
            editor.getWorkflow().keyTyped(e.getKeyChar());
        }
    }
}

