/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.groupEditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import jsesh.mdc.constants.TextDirection;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdcDisplayer.draw.ViewDrawer;
import jsesh.mdcDisplayer.layout.MDCEditorKit;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.mdcDisplayer.swing.groupEditor.GroupEditorEvent;
import jsesh.mdcDisplayer.swing.groupEditor.GroupEditorListener;
import jsesh.swingUtils.GraphicsUtils;

public class GroupEditor
extends JPanel {
    public static final int RESIZE = 1;
    public static final int ROTATION = 2;
    DrawingSpecifications drawingSpecifications = MDCEditorKit.getBasicMDCEditorKit().getDrawingSpecifications();
    private AbsoluteGroup group;
    private ArrayList groupEditorEventListeners = new ArrayList();
    private int handleSize = 10;
    private int lineWidth = 2;
    private int mode = 1;
    private double scale = 10.0;
    private int selected = -1;
    private double sideMargin = 5.0;
    private double topMargin = 5.0;

    public GroupEditor() {
        this.setBackground(Color.WHITE);
        LowLevelControl control = new LowLevelControl();
        this.addMouseListener(control);
        this.addMouseMotionListener(control);
        this.drawingSpecifications = this.drawingSpecifications.copy();
        this.drawingSpecifications.setTextDirection(TextDirection.LEFT_TO_RIGHT);
    }

    public void addGroupEditorEventListener(GroupEditorListener l) {
        this.groupEditorEventListeners.add(l);
    }

    private GroupEditorEvent buildEvent(MouseEvent e) {
        GroupEditorEvent result = null;
        Point2D p = this.getModelPoint(e.getPoint());
        MDCView v = this.getView();
        if (this.selected != -1) {
            MDCView subv = v.getSubView(this.selected);
            Handle[] handles = this.getHandles(subv);
            for (int i = 0; result == null && i < handles.length; ++i) {
                if (!handles[i].shape.contains(p)) continue;
                result = new GroupEditorEvent(this.group, p, this.selected, handles[i].hpos, handles[i].vpos);
            }
        }
        for (int i = 0; result == null && i < v.getNumberOfSubviews(); ++i) {
            MDCView subv = v.getSubView(i);
            Hieroglyph h = this.group.getHieroglyphAt(i);
            double sc = (double)this.drawingSpecifications.getBaseLength() / 100.0;
            Area s1 = this.drawingSpecifications.getHieroglyphsDrawer().getSignArea(h.getCode(), subv.getPosition().x, subv.getPosition().y, (double)h.getRelativeSize() / 100.0, (double)h.getRelativeSize() / 100.0, h.getAngle(), h.isReversed());
            if (!s1.contains(p)) continue;
            result = new GroupEditorEvent(this.group, p, i);
        }
        if (result == null) {
            result = new GroupEditorEvent(this.group, p, -1);
        }
        return result;
    }

    private Handle buildHandle(double x, double y, double diameter, int hpos, int vpos) {
        RectangularShape shape = this.mode == 2 ? new Ellipse2D.Double(x, y, diameter, diameter) : new Rectangle2D.Double(x, y, diameter, diameter);
        return new Handle(shape, hpos, vpos);
    }

    public AbsoluteGroup getGroup() {
        return this.group;
    }

    private Handle[] getHandles(MDCView v) {
        Handle[] result = new Handle[8];
        Point2D orig = this.getViewPosition(v);
        double w = v.getWidth();
        double h = v.getHeight();
        double radius = (double)this.handleSize / (2.0 * this.scale);
        double diameter = 2.0 * radius;
        int i = 0;
        result[i++] = this.buildHandle(orig.getX() - radius, orig.getY() - radius, diameter, 3, 1);
        result[i++] = this.buildHandle(orig.getX() - radius + w / 2.0, orig.getY() - radius, diameter, 0, 1);
        result[i++] = this.buildHandle(orig.getX() - radius + w, orig.getY() - radius, diameter, 4, 1);
        result[i++] = this.buildHandle(orig.getX() - radius, orig.getY() + h / 2.0 - radius, diameter, 3, 0);
        result[i++] = this.buildHandle(orig.getX() - radius + w, orig.getY() + h / 2.0 - radius, diameter, 4, 0);
        result[i++] = this.buildHandle(orig.getX() - radius, orig.getY() + h - radius, diameter, 3, 2);
        result[i++] = this.buildHandle(orig.getX() - radius + w / 2.0, orig.getY() + h - radius, diameter, 0, 2);
        result[i++] = this.buildHandle(orig.getX() - radius + w, orig.getY() + h - radius, diameter, 4, 2);
        return result;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getMode() {
        return this.mode;
    }

    private Point2D getModelPoint(Point p) {
        double x = p.getX() / this.scale - this.sideMargin;
        double y = p.getY() / this.scale - this.topMargin;
        return new Point2D.Double(x, y);
    }

    public Dimension getPreferredSize() {
        if (this.group == null) {
            return new Dimension(640, 480);
        }
        MDCView v = this.getView();
        int w = (int)(((double)v.getWidth() + 2.0 * this.sideMargin) * this.scale);
        int h = (int)(((double)v.getHeight() + 2.0 * this.topMargin) * this.scale);
        return new Dimension(w, h);
    }

    public double getScale() {
        return this.scale;
    }

    public int getSelected() {
        return this.selected;
    }

    public double getSideMargin() {
        return this.sideMargin;
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    private MDCView getView() {
        MDCView view = null;
        if (this.group != null) {
            SimpleViewBuilder builder = new SimpleViewBuilder();
            view = builder.buildView(this.group, this.drawingSpecifications);
        } else {
            view = new MDCView(null);
        }
        return view;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        MDCView view = this.getView();
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtils.antialias(g);
        g2d.scale(this.scale, this.scale);
        g2d.translate(this.sideMargin, this.topMargin);
        double wd = (double)this.lineWidth / g2d.getTransform().getScaleX();
        if (this.group != null) {
            ViewDrawer drawer = new ViewDrawer();
            drawer.draw(g2d, view, this.drawingSpecifications);
            if (this.selected >= 0) {
                MDCView v = view.getSubView(this.selected);
                Point2D orig = this.getViewPosition(v);
                double w = v.getWidth();
                double h = v.getHeight();
                g2d.setColor(Color.RED);
                g2d.setStroke(new BasicStroke((float)wd));
                g2d.draw(new Rectangle2D.Double(orig.getX(), orig.getY(), w, h));
                Handle[] handles = this.getHandles(v);
                for (int i = 0; i < handles.length; ++i) {
                    g2d.draw(handles[i].shape);
                }
            }
        }
        g2d.setColor(Color.RED);
        float[] f = new float[]{0.5f, 1.0f};
        g2d.setStroke(new BasicStroke((float)(wd / 2.0), 1, 0, 2.0f, f, 0.0f));
        g2d.draw(new Line2D.Double(0.0, 0.0, 1000.0, 0.0));
        g2d.draw(new Line2D.Double(0.0, 0.0, 0.0, 1000.0));
    }

    public void removeGroupEditorEventListener(GroupEditorListener l) {
        this.groupEditorEventListeners.remove(l);
    }

    public void setGroup(AbsoluteGroup group) {
        this.group = group;
        this.selected = -1;
        this.revalidate();
    }

    public void setHandleSize(int handleSize) {
        this.handleSize = handleSize;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.repaint();
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.revalidate();
    }

    public void setSelected(int selected) {
        this.selected = selected;
        this.repaint();
    }

    public void setSideMargin(double sideMargin) {
        this.sideMargin = sideMargin;
        this.revalidate();
    }

    public void setTopMargin(double topMargin) {
        this.topMargin = topMargin;
        this.revalidate();
    }

    public void rotate(double angle) {
        this.revalidate();
        this.repaint();
    }

    public void move(double dx, double dy) {
        if (this.selected != -1) {
            MDCView v = this.getView().getSubView(this.selected);
            Point2D p = this.getViewPosition(v);
            double x = p.getX() + dx;
            double y = p.getY() + dy;
            double unitSize = 1000.0 / (double)this.drawingSpecifications.getBaseLength();
            Hieroglyph h = this.group.getHieroglyphAt(this.selected);
            h.setExplicitPosition((int)(x *= unitSize), (int)(y *= unitSize), h.getRelativeSize());
            this.revalidate();
            this.repaint();
        }
    }

    public void resizeTo(double dx, double dy, int horizontalHandlePosition, int verticalHandlePosition) {
        if (this.selected != -1) {
            double scale = 1.0;
            MDCView v = this.getView().getSubView(this.selected);
            Point2D orig = this.getViewPosition(v);
            double x = orig.getX();
            double y = orig.getY();
            if (horizontalHandlePosition != 0) {
                double newWidth;
                if (horizontalHandlePosition == 3) {
                    newWidth = (double)v.getWidth() - dx;
                    x += dx;
                } else {
                    newWidth = (double)v.getWidth() + dx;
                }
                if (newWidth > 0.0) {
                    scale = newWidth / (double)v.getWidth();
                }
            } else {
                double newHeight;
                if (verticalHandlePosition == 1) {
                    newHeight = (double)v.getHeight() - dy;
                    y += dy;
                } else {
                    newHeight = (double)v.getHeight() + dy;
                }
                if (newHeight > 0.0) {
                    scale = newHeight / (double)v.getHeight();
                }
            }
            Hieroglyph h = this.group.getHieroglyphAt(this.selected);
            double unitSize = 1000.0 / (double)this.drawingSpecifications.getBaseLength();
            x *= unitSize;
            y *= unitSize;
            scale *= (double)h.getRelativeSize();
            if (scale < 5.0) {
                scale = 5.0;
            }
            h.setExplicitPosition((int)x, (int)y, (int)scale);
            this.repaint();
            this.invalidate();
        }
    }

    private Point2D getViewPosition(MDCView subview) {
        return new Point2D.Double(subview.getPosition().x, subview.getPosition().y);
    }

    public void reverse() {
    }

    public void rotate(Point2D p1, Point2D p2) {
        if (this.selected != -1) {
            MDCView v = this.getView().getSubView(this.selected);
            Point2D orig = this.getViewPosition(v);
            Point2D.Double center = new Point2D.Double(orig.getX() + (double)(v.getWidth() / 2.0f), orig.getY() + (double)(v.getHeight() / 2.0f));
            Point2D.Double v1 = new Point2D.Double(p1.getX() - ((Point2D)center).getX(), p1.getY() - ((Point2D)center).getY());
            Point2D.Double v2 = new Point2D.Double(p2.getX() - ((Point2D)center).getX(), p2.getY() - ((Point2D)center).getY());
            double d1 = v1.distance(0.0, 0.0);
            double d2 = v2.distance(0.0, 0.0);
            if (d1 == 0.0 || d2 == 0.0) {
                return;
            }
            double cos = (((Point2D)v1).getX() * ((Point2D)v2).getX() + ((Point2D)v1).getY() * ((Point2D)v2).getY()) / (d1 * d2);
            double sin = (((Point2D)v1).getX() * ((Point2D)v2).getY() - ((Point2D)v1).getY() * ((Point2D)v2).getX()) / (d1 * d2);
            double alpha = Math.acos(cos);
            if (sin < 0.0) {
                alpha = Math.PI * 2 - alpha;
            }
            Hieroglyph h = this.group.getHieroglyphAt(this.selected);
            double angle = alpha * 180.0 / Math.PI + (double)h.getAngle();
            h.setAngle((int)angle);
            this.repaint();
            this.revalidate();
        }
    }

    public void rotate(int angle) {
        if (this.selected != -1) {
            Hieroglyph h = this.group.getHieroglyphAt(this.selected);
            h.setAngle(angle);
            this.repaint();
            this.revalidate();
        }
    }

    public void resetSign() {
        if (this.selected != -1) {
            Hieroglyph h = this.group.getHieroglyphAt(this.selected);
            h.setExplicitPosition(0, 0, 100);
            this.repaint();
            this.revalidate();
        }
    }

    public void next() {
        if (this.group != null) {
            this.selected = (this.selected + 2) % (this.group.getNumberOfChildren() + 1) - 1;
            this.repaint();
        }
    }

    public void previous() {
        if (this.group != null) {
            --this.selected;
            if (this.selected == -2) {
                this.selected = this.group.getNumberOfChildren() - 1;
            }
            this.repaint();
        }
    }

    class LowLevelControl
    implements MouseInputListener {
        LowLevelControl() {
        }

        public void mouseClicked(MouseEvent e) {
            for (int i = 0; i < GroupEditor.this.groupEditorEventListeners.size(); ++i) {
                ((GroupEditorListener)GroupEditor.this.groupEditorEventListeners.get(i)).mouseClicked(GroupEditor.this.buildEvent(e));
            }
        }

        public void mouseDragged(MouseEvent e) {
            for (int i = 0; i < GroupEditor.this.groupEditorEventListeners.size(); ++i) {
                ((GroupEditorListener)GroupEditor.this.groupEditorEventListeners.get(i)).mouseDragged(GroupEditor.this.buildEvent(e));
            }
        }

        public void mouseEntered(MouseEvent e) {
            for (int i = 0; i < GroupEditor.this.groupEditorEventListeners.size(); ++i) {
                ((GroupEditorListener)GroupEditor.this.groupEditorEventListeners.get(i)).mouseEntered(GroupEditor.this.buildEvent(e));
            }
        }

        public void mouseExited(MouseEvent e) {
            for (int i = 0; i < GroupEditor.this.groupEditorEventListeners.size(); ++i) {
                ((GroupEditorListener)GroupEditor.this.groupEditorEventListeners.get(i)).mouseExited(GroupEditor.this.buildEvent(e));
            }
        }

        public void mouseMoved(MouseEvent e) {
            for (int i = 0; i < GroupEditor.this.groupEditorEventListeners.size(); ++i) {
                ((GroupEditorListener)GroupEditor.this.groupEditorEventListeners.get(i)).mouseMoved(GroupEditor.this.buildEvent(e));
            }
        }

        public void mousePressed(MouseEvent e) {
            for (int i = 0; i < GroupEditor.this.groupEditorEventListeners.size(); ++i) {
                ((GroupEditorListener)GroupEditor.this.groupEditorEventListeners.get(i)).mousePressed(GroupEditor.this.buildEvent(e));
            }
        }

        public void mouseReleased(MouseEvent e) {
            for (int i = 0; i < GroupEditor.this.groupEditorEventListeners.size(); ++i) {
                ((GroupEditorListener)GroupEditor.this.groupEditorEventListeners.get(i)).mouseReleased(GroupEditor.this.buildEvent(e));
            }
        }
    }

    private static class Handle {
        public Shape shape;
        public int vpos;
        public int hpos;

        public Handle(Shape shape, int hpos, int vpos) {
            this.shape = shape;
            this.vpos = vpos;
            this.hpos = hpos;
        }
    }
}

