/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.groupEditor;

import java.awt.geom.Point2D;
import jsesh.mdcDisplayer.swing.groupEditor.GroupEditor;
import jsesh.mdcDisplayer.swing.groupEditor.GroupEditorEvent;
import jsesh.mdcDisplayer.swing.groupEditor.GroupEditorListener;

class GroupEditorControl
implements GroupEditorListener {
    private GroupEditor editor;
    Point2D oldPoint;
    int horizontalHandle;
    int verticalHandle;
    boolean handleSelected;

    public GroupEditorControl(GroupEditor editor) {
        this.editor = editor;
        editor.addGroupEditorEventListener(this);
        this.handleSelected = false;
    }

    public void mouseClicked(GroupEditorEvent e) {
    }

    public void mouseEntered(GroupEditorEvent e) {
    }

    public void mouseExited(GroupEditorEvent e) {
    }

    public void mousePressed(GroupEditorEvent e) {
        this.editor.setSelected(e.getElementIndex());
        this.handleSelected = e.isOnHandle();
        if (e.isOnHandle()) {
            this.horizontalHandle = e.getHorizontalHandlePosition();
            this.verticalHandle = e.getVerticalHandlePosition();
        }
        if (e.getElementIndex() != -1) {
            this.oldPoint = new Point2D.Double(e.getPoint().getX(), e.getPoint().getY());
        }
    }

    public void mouseReleased(GroupEditorEvent e) {
        this.oldPoint = null;
    }

    public void mouseDragged(GroupEditorEvent e) {
        if (this.editor.getSelected() != -1 && this.oldPoint != null) {
            if (this.handleSelected) {
                if (this.editor.getMode() == 1) {
                    Point2D p = e.getPoint();
                    double dx = p.getX() - this.oldPoint.getX();
                    double dy = p.getY() - this.oldPoint.getY();
                    this.editor.resizeTo(dx, dy, this.horizontalHandle, this.verticalHandle);
                    this.oldPoint.setLocation(p.getX(), p.getY());
                } else {
                    Point2D p = e.getPoint();
                    this.editor.rotate(this.oldPoint, p);
                    this.oldPoint.setLocation(p.getX(), p.getY());
                }
            } else {
                Point2D p = e.getPoint();
                double dx = p.getX() - this.oldPoint.getX();
                double dy = p.getY() - this.oldPoint.getY();
                this.oldPoint.setLocation(p.getX(), p.getY());
                this.editor.move(dx, dy);
            }
        }
    }

    public void mouseMoved(GroupEditorEvent e) {
    }
}

