/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.groupEditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import jsesh.mdc.model.AbsoluteGroup;
import jsesh.mdc.model.Hieroglyph;
import jsesh.mdc.model.TopItemList;
import jsesh.mdc.output.ModelWriter;
import jsesh.mdcDisplayer.swing.groupEditor.GroupEditor;
import jsesh.mdcDisplayer.swing.groupEditor.GroupEditorControl;

public class GroupEditorDialog
extends JPanel {
    private JButton next;
    private JButton previous;
    private JButton reset;
    private JToggleButton rotate;
    private JToggleButton resize;
    private GroupEditor editor;

    public GroupEditorDialog() {
        this.setBackground(Color.WHITE);
        this.editor = new GroupEditor();
        GroupEditorControl control = new GroupEditorControl(this.editor);
        GroupEditorDialogListener l = new GroupEditorDialogListener();
        this.next = new JButton("next");
        this.previous = new JButton("previous");
        this.reset = new JButton("reset");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rotate = new JToggleButton("rotate");
        this.resize = new JToggleButton("resize");
        buttonGroup.add(this.rotate);
        buttonGroup.add(this.resize);
        JToolBar sub = new JToolBar(0);
        sub.add(this.previous);
        this.previous.addActionListener(l);
        sub.add(this.next);
        this.next.addActionListener(l);
        sub.add(this.reset);
        this.reset.addActionListener(l);
        sub.add(this.rotate);
        this.rotate.addActionListener(l);
        sub.add(this.resize);
        this.resize.addActionListener(l);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.editor), "Center");
        this.add((Component)sub, "South");
        this.setPreferredSize(new Dimension(640, 480));
    }

    public void setGroup(AbsoluteGroup group) {
        this.editor.setGroup(group);
    }

    public AbsoluteGroup getGroup() {
        return this.editor.getGroup();
    }

    public static void main(String[] args) {
        AbsoluteGroup g = new AbsoluteGroup();
        g.addHieroglyph(new Hieroglyph("t"));
        g.addHieroglyph(new Hieroglyph("A"));
        g.addHieroglyph(new Hieroglyph("x"));
        g.addHieroglyph(new Hieroglyph("anx"));
        final GroupEditorDialog editor = new GroupEditorDialog();
        editor.setGroup(g);
        JFrame f = new JFrame();
        f.getContentPane().add(editor);
        f.pack();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ModelWriter m = new ModelWriter();
                TopItemList l = new TopItemList();
                editor.getGroup().compact();
                l.addTopItem(editor.getGroup().buildTopItem());
                try {
                    OutputStreamWriter w = new OutputStreamWriter(System.out);
                    m.write(w, l);
                    w.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                System.exit(0);
            }
        });
        f.setVisible(true);
    }

    private class GroupEditorDialogListener
    implements ActionListener {
        private GroupEditorDialogListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GroupEditorDialog.this.next) {
                GroupEditorDialog.this.editor.next();
            } else if (e.getSource() == GroupEditorDialog.this.previous) {
                GroupEditorDialog.this.editor.previous();
            } else if (e.getSource() == GroupEditorDialog.this.rotate) {
                GroupEditorDialog.this.editor.setMode(2);
            } else if (e.getSource() == GroupEditorDialog.this.resize) {
                GroupEditorDialog.this.editor.setMode(1);
            } else if (e.getSource() == GroupEditorDialog.this.reset) {
                GroupEditorDialog.this.editor.resetSign();
            }
        }
    }
}

