/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.hieroglyphicMenu;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jsesh.bzr.simple.ShapeChar;
import jsesh.hieroglyphs.DefaultHieroglyphicFontManager;
import jsesh.hieroglyphs.HieroglyphicBitmapBuilder;
import jsesh.hieroglyphs.HieroglyphsManager;
import jsesh.mdcDisplayer.swing.hieroglyphicMenu.HieroglyphicMenuListener;

public class HieroglyphicMenu
extends JMenu {
    private int size = 30;
    private int border = 2;
    private int ncols;
    private String family;
    private HieroglyphicMenuListener hieroglyphicMenuListener = null;
    private boolean menuFilled = false;

    public HieroglyphicMenu(String title, String family, int ncols) {
        super(title);
        this.ncols = ncols;
        this.family = family;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("menu selected");
            }
        });
        this.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                HieroglyphicMenu.this.fillMenu();
            }
        });
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
                HieroglyphicMenu.this.flushMenu();
            }

            public void menuDeselected(MenuEvent e) {
                HieroglyphicMenu.this.flushMenu();
            }

            public void menuSelected(MenuEvent e) {
            }
        });
    }

    private void fillMenu() {
        if (this.menuFilled) {
            return;
        }
        this.menuFilled = true;
        String[] codes = HieroglyphsManager.getInstance().getCodesForFamily(this.family, true);
        CodeSelector menuEnter = new CodeSelector();
        JPopupMenu pm = this.getPopupMenu();
        pm.setLayout(new GridLayout(0, this.ncols));
        for (int i = 0; i < codes.length; ++i) {
            HieroglyphAction a = new HieroglyphAction(codes[i]);
            JMenuItem jm = new JMenuItem(a);
            jm.addMouseListener(menuEnter);
            this.add(jm);
        }
    }

    private void flushMenu() {
        this.removeAll();
        this.menuFilled = false;
    }

    public void setHieroglyphicMenuListener(HieroglyphicMenuListener hieroglyphicMenuListener) {
        this.hieroglyphicMenuListener = hieroglyphicMenuListener;
    }

    public Icon createHieroglyphIcon(String code, int size, int border) {
        DefaultHieroglyphicFontManager manager = DefaultHieroglyphicFontManager.getInstance();
        ShapeChar glyph = manager.get(code);
        HieroglyphicBitmapBuilder builder = new HieroglyphicBitmapBuilder(20.0, 30, false);
        builder.setBorder(2);
        builder.setFit(true);
        builder.setComponent(this);
        BufferedImage img = builder.buildSignBitmap(glyph);
        return new ImageIcon(img);
    }

    class CodeSelector
    extends MouseAdapter {
        CodeSelector() {
        }

        public void mouseEntered(MouseEvent e) {
            if (HieroglyphicMenu.this.hieroglyphicMenuListener != null) {
                JMenuItem item = (JMenuItem)e.getSource();
                HieroglyphAction action = (HieroglyphAction)item.getAction();
                HieroglyphicMenu.this.hieroglyphicMenuListener.enter(action.code);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (HieroglyphicMenu.this.hieroglyphicMenuListener != null) {
                JMenuItem item = (JMenuItem)e.getSource();
                HieroglyphAction action = (HieroglyphAction)item.getAction();
                HieroglyphicMenu.this.hieroglyphicMenuListener.exit(action.code);
            }
        }
    }

    class HieroglyphAction
    extends AbstractAction {
        String code;

        public HieroglyphAction(String code) {
            super(code, HieroglyphicMenu.this.createHieroglyphIcon(code, HieroglyphicMenu.this.size, HieroglyphicMenu.this.border));
            this.code = code;
        }

        public void actionPerformed(ActionEvent e) {
            if (HieroglyphicMenu.this.hieroglyphicMenuListener != null) {
                HieroglyphicMenu.this.hieroglyphicMenuListener.codeSelected(this.code);
            }
        }
    }
}

