/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdcDisplayer.swing.units;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class LengthUnit {
    public static final LengthUnit POINT = new LengthUnit("Point", 1.0);
    public static final LengthUnit INCH = new LengthUnit("Inch", 72.0);
    public static final LengthUnit MM = new LengthUnit("mm", 2.834645669291339);
    public static final LengthUnit[] UNITS = new LengthUnit[]{POINT, INCH, MM};
    private String name;
    private double pointsValue;

    public LengthUnit(String name, double value) {
        this.name = name;
        this.pointsValue = value;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public double getPointsValue() {
        return this.pointsValue;
    }

    public static void attachToCombobox(JComboBox combobox, LengthUnit unit) {
        combobox.setModel(new DefaultComboBoxModel<LengthUnit>(UNITS));
        combobox.setSelectedItem(unit);
    }

    public Double convert(int length) {
        return new Double((double)length / this.pointsValue);
    }
}

