/*
 * Decompiled with CFR 0.152.
 */
package jsesh.resources;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import jsesh.utils.PlatformDetection;

public class ResourcesManager {
    private static ResourcesManager instance;
    private Font transliterationFont;
    public static String ICONDEFINITIONS;
    private Map iconMap = new HashMap();

    private ResourcesManager() {
        this.loadFonts();
        this.loadIcons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIcons() {
        try {
            BufferedReader r = null;
            try {
                String s;
                r = new BufferedReader(new InputStreamReader(ResourcesManager.class.getResourceAsStream(ICONDEFINITIONS)));
                while ((s = r.readLine()) != null) {
                    String[] data = s.split(":");
                    this.iconMap.put(data[0], new ImageIcon((class$jsesh$resources$ResourcesManager == null ? ResourcesManager.class$("jsesh.resources.ResourcesManager") : class$jsesh$resources$ResourcesManager).getResource("/jseshResources/" + data[1])));
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadFonts() {
        block15: {
            InputStream in = null;
            in = ResourcesManager.class.getResourceAsStream("/jseshResources/fonts/MDCTranslitLC.ttf");
            if (in == null) {
                throw new FileNotFoundException("file not found");
            }
            this.transliterationFont = Font.createFont(0, in);
            this.transliterationFont = this.transliterationFont.deriveFont(12.0f);
            Object var4_2 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block15;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            break block15;
            {
                catch (FontFormatException e) {
                    System.err.println("problem with font file format " + e);
                    e.printStackTrace();
                    this.transliterationFont = new Font(null, 2, 12);
                    Object var4_3 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block15;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    break block15;
                }
                catch (IOException e) {
                    System.err.println("problem with font loading " + e);
                    this.transliterationFont = new Font(null, 2, 12);
                    e.printStackTrace();
                    Object var4_4 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block15;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public static ResourcesManager getInstance() {
        if (instance == null) {
            instance = new ResourcesManager();
        }
        return instance;
    }

    public Font getTransliterationFont() {
        return this.transliterationFont;
    }

    public Reader getLigatureData() {
        InputStreamReader in = new InputStreamReader(ResourcesManager.class.getResourceAsStream("/jseshResources/data/ligatures.txt"));
        return in;
    }

    public Reader getDemoData() {
        InputStreamReader in = new InputStreamReader(ResourcesManager.class.getResourceAsStream("/jseshResources/data/allmdc.gly"));
        return in;
    }

    public File getUserPrefsDirectory() {
        File result = new File(System.getProperty("user.home"));
        if (PlatformDetection.getPlatform() == 1) {
            result = new File(result, "Library");
            result = new File(result, "Preferences");
            result = new File(result, "JSesh");
        } else {
            result = PlatformDetection.getPlatform() == 2 ? new File(result, "JSeshData") : new File(result, ".jsesh");
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public ImageIcon getIcon(String symbolicName) {
        if (this.iconMap.containsKey(symbolicName)) {
            return (ImageIcon)this.iconMap.get(symbolicName);
        }
        return (ImageIcon)this.iconMap.get("Dummy");
    }

    static {
        ICONDEFINITIONS = "/jseshResources/iconsDefinitions.txt";
    }
}

