/*
 * Decompiled with CFR 0.152.
 */
package jsesh.softwares;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import jsesh.bzr.simple.ShapeChar;
import jsesh.hieroglyphs.DefaultHieroglyphicFontManager;
import jsesh.hieroglyphs.HieroglyphicBitmapBuilder;
import jsesh.hieroglyphs.HieroglyphsManager;

public class MakeGlyphsIndex {
    static final String USAGE = "usage : \n java " + MakeGlyphsIndex.class.getName() + "FORMAT  [FAMILY]" + "\n\twhere " + "\n\t\tFORMAT is \"png\" or \"svg\"" + "\n\t\tFAMILY is the name of a gardiner font family, or US + user id" + "\n\tif no family is provided, all known fonts will be dumped.";

    public static void main(String[] args) throws IOException {
        if (args.length > 2 || args.length == 0) {
            MakeGlyphsIndex.displayUsage();
        }
        String format = args[0];
        String family = "";
        if (args.length == 2) {
            family = args[1];
        }
        if (!"png".equals(format) && !"svg".equals(format)) {
            MakeGlyphsIndex.displayUsage();
        }
        String[] codes = HieroglyphsManager.getInstance().getCodesForFamily(family, false);
        for (int i = 0; i < codes.length; ++i) {
            MakeGlyphsIndex.dumpSign(codes[i], format);
        }
    }

    private static void dumpSign(String code, String format) throws IOException {
        DefaultHieroglyphicFontManager manager = DefaultHieroglyphicFontManager.getInstance();
        ShapeChar s = manager.get(code);
        if ("png".equals(format)) {
            HieroglyphicBitmapBuilder bitmapBuilder = new HieroglyphicBitmapBuilder();
            bitmapBuilder.setFit(true);
            BufferedImage bitmap = bitmapBuilder.buildSignBitmap(s);
            ImageIO.write((RenderedImage)bitmap, "png", new File(code + ".png"));
        } else if ("svg".equals(format)) {
            FileOutputStream out = new FileOutputStream(code + ".svg");
            s.exportToSVG(out, "US-ASCII");
        }
    }

    public static void displayUsage() {
        System.err.println(USAGE);
        System.exit(1);
    }
}

