/*
 * Decompiled with CFR 0.152.
 */
package jsesh.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class TclImporter {
    private StreamTokenizer tok;

    public List parseTclList(Reader r) throws IOException {
        this.tok = new StreamTokenizer(r);
        this.tok.nextToken();
        List result = this.parseTclListAux();
        if (this.tok.ttype != -1) {
            throw new IOException("Bad Tcl list");
        }
        this.tok = null;
        return result;
    }

    private List parseTclListAux() throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        boolean ended = false;
        block7: while (!ended) {
            switch (this.tok.ttype) {
                case -3: {
                    result.add(this.tok.sval);
                    this.tok.nextToken();
                    continue block7;
                }
                case -2: {
                    result.add(new Double(this.tok.nval));
                    this.tok.nextToken();
                    continue block7;
                }
                case 123: {
                    this.tok.nextToken();
                    result.add(this.parseTclListAux());
                    if (this.tok.ttype != 125) {
                        throw new IOException("'}' expected");
                    }
                    this.tok.nextToken();
                    continue block7;
                }
                case 125: {
                    ended = true;
                    continue block7;
                }
                case -1: {
                    ended = true;
                    continue block7;
                }
            }
            result.add("" + (char)this.tok.ttype);
            this.tok.nextToken();
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        TclImporter importer = new TclImporter();
        List result = importer.parseTclList(new StringReader("a b c {z z1} 3 {d e cf { 23.2 -1.4}} {h i}"));
        System.out.println(result);
        result = importer.parseTclList(new StringReader("a b c {d e cf { 23.2 -1.4} {h i"));
        System.out.println(result);
    }
}

