/*
 * Decompiled with CFR 0.152.
 */
package jsesh.deprecated;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jsesh.deprecated.Messages;
import jsesh.graphicExport.ExportFileType;
import jsesh.graphics.generic.BaseGraphics2D;
import jsesh.graphics.generic.BaseGraphics2DException;
import jsesh.mdcDisplayer.draw.ViewPrinter;
import jsesh.mdcDisplayer.swing.editor.HieroglyphicTextModel;

public abstract class PagedExporter
extends AbstractAction {
    protected Component parent;
    protected HieroglyphicTextModel data;
    protected Properties properties;
    double scale;

    public PagedExporter(HieroglyphicTextModel data, Component parent, String name) {
        super(name);
        this.data = data;
        this.parent = parent;
        this.properties = new Properties();
        this.scale = 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        try {
            JFileChooser chooser = new JFileChooser();
            ExportFileType export = this.getExportFileType();
            JPanel panel = export.createOptionPanel(this.properties);
            int rc = JOptionPane.showConfirmDialog(this.parent, panel, this.getOptionsTitle(), 2, -1);
            if (rc != 0) {
                return;
            }
            export.applyChangedOptions(panel, this.properties);
            chooser.setFileFilter(export.getFileFilter());
            int returnval = chooser.showSaveDialog(this.parent);
            if (returnval != 0) {
                return;
            }
            File outputFile = chooser.getSelectedFile();
            if (!export.fileHasValidExtension(outputFile)) {
                export.adjustFilename(outputFile, this.properties);
            }
            if (outputFile.exists() && (returnval = JOptionPane.showConfirmDialog(this.parent, Messages.getString("PagedExporter.File") + outputFile.getName() + Messages.getString("PagedExporter.exists.continue"), Messages.getString("PagedExporter.file.exists"), 2, 2)) == 2) {
                return;
            }
            BaseGraphics2D g = this.getGraphics(outputFile);
            g.setProperties(this.properties);
            Dimension d = this.getDimension();
            PageFormat pageFormat = new PageFormat();
            Paper p = new Paper();
            p.setSize(d.getWidth(), d.getHeight());
            p.setImageableArea(0.0, 0.0, d.getWidth(), d.getHeight());
            pageFormat.setPaper(p);
            ViewPrinter printer = new ViewPrinter();
            printer.setModel(this.data.getModel());
            printer.setPageformat(pageFormat);
            Dimension dimension = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableWidth());
            g.scale(this.scale, this.scale);
            for (int i = 0; i < printer.getNumberOfPages(); ++i) {
                try {
                    g.openPage(dimension, Messages.getString("PagedExporter.page") + (i + 1));
                    printer.print(g, pageFormat, i);
                    continue;
                }
                catch (PrinterException e2) {
                    e2.printStackTrace();
                    continue;
                }
                catch (BaseGraphics2DException e1) {
                    e1.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        g.closePage();
                    }
                    catch (BaseGraphics2DException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            g.dispose();
        }
        catch (HeadlessException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(this.parent, Messages.getString("PagedExporter.cant.open.file"), Messages.getString("PagedExporter.error"), 0);
        }
        catch (OutOfMemoryError err) {
            JOptionPane.showMessageDialog(this.parent, Messages.getString("PagedExporter.out.of.memory"), Messages.getString("PagedExporter.error"), 0);
        }
    }

    public abstract ExportFileType getExportFileType();

    protected abstract BaseGraphics2D getGraphics(File var1) throws FileNotFoundException;

    protected abstract String getOptionsTitle();

    protected abstract Dimension getDimension();

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

