/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.model;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jsesh.bzr.simple.ShapeChar;
import jsesh.externalFonts.model.SimpleSignSourceModel;

public class TTFSignSource
implements SimpleSignSourceModel {
    int currentPos = 0;
    ArrayList shapes;

    public TTFSignSource(File file) throws IOException {
        try {
            FileInputStream in = new FileInputStream(file);
            Font f = Font.createFont(0, in);
            f = f.deriveFont(14.0f);
            ((InputStream)in).close();
            this.shapes = new ArrayList();
            int max = 65535;
            for (int i = 0; i <= max; ++i) {
                if (!f.canDisplay((char)i)) continue;
                ShapeChar s = new ShapeChar();
                Shape shape = f.createGlyphVector(new FontRenderContext(null, false, true), "" + (char)i).getOutline();
                s.setShape(shape);
                s.fixShape();
                Rectangle2D bbox = s.getBbox();
                if (bbox.getWidth() == 0.0 && bbox.getHeight() == 0.0) continue;
                this.shapes.add(s);
            }
        }
        catch (FontFormatException e) {
            throw new IOException("Error in File");
        }
        this.beforeFirst();
    }

    public ShapeChar getCurrentShape() {
        return (ShapeChar)this.shapes.get(this.currentPos);
    }

    public boolean hasNext() {
        return this.currentPos + 1 < this.shapes.size();
    }

    public boolean hasPrevious() {
        return this.currentPos > 0;
    }

    public void next() {
        ++this.currentPos;
    }

    public void previous() {
        --this.currentPos;
    }

    public String getCurrentCode() {
        return "";
    }

    public void afterLast() {
        this.currentPos = this.shapes.size();
    }

    public void beforeFirst() {
        this.currentPos = -1;
    }
}

