/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.model;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jsesh.bzr.simple.ShapeChar;
import jsesh.externalFonts.model.SimpleSignSourceModel;
import jsesh.utils.TclImporter;

public class TmlSignsImporter
implements SimpleSignSourceModel {
    private TreeMap signs = new TreeMap();
    private Map codeMap = new TreeMap();
    private String[] codeList;
    int pos;

    public TmlSignsImporter(Reader r) throws IOException {
        List l = new TclImporter().parseTclList(r);
        r.close();
        this.parseList(l);
        this.codeList = this.signs.keySet().toArray(new String[this.signs.keySet().size()]);
        this.beforeFirst();
    }

    private void parseList(List l) {
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            List elt;
            Object o = iter.next();
            if (!(o instanceof List) || (elt = (List)o).size() <= 0) continue;
            if ("Glyph".equals(elt.get(0).toString())) {
                this.parseGlyph(elt);
                continue;
            }
            if (!"HasCode".equals(elt.get(0).toString())) continue;
            this.parseHasCode(elt);
        }
    }

    private void parseHasCode(List elt) {
        int uid = ((Double)elt.get(6)).intValue();
        int mid = ((Double)elt.get(7)).intValue();
        int id = ((Double)elt.get(8)).intValue();
        String mdc = (String)elt.get(9);
        String stdCode = "UG" + uid + "M" + mid + "N" + id;
        this.codeMap.put(stdCode, mdc);
    }

    private void parseGlyph(List elt) {
        ShapeChar newSign = new ShapeChar();
        Area area = new Area();
        int uid = ((Double)elt.get(1)).intValue();
        int mid = ((Double)elt.get(2)).intValue();
        int id = ((Double)elt.get(3)).intValue();
        List glyph = (List)elt.get(6);
        for (int i = 6; i < glyph.size(); ++i) {
            GeneralPath subPath = new GeneralPath();
            List contour = (List)glyph.get(i);
            float startx = ((Double)contour.get(2)).floatValue();
            float starty = ((Double)contour.get(3)).floatValue();
            subPath.moveTo(startx, starty);
            for (int k = 4; k < contour.size(); ++k) {
                List segment = (List)contour.get(k);
                char codeSegment = segment.get(0).toString().charAt(0);
                if (codeSegment == 's') {
                    float c1x = ((Double)segment.get(1)).floatValue();
                    float c1y = ((Double)segment.get(2)).floatValue();
                    float c2x = ((Double)segment.get(3)).floatValue();
                    float c2y = ((Double)segment.get(4)).floatValue();
                    float x = ((Double)segment.get(5)).floatValue();
                    float y = ((Double)segment.get(6)).floatValue();
                    subPath.curveTo(c1x, c1y, c2x, c2y, x, y);
                    continue;
                }
                if (codeSegment != 'l') continue;
                float x = ((Double)segment.get(1)).floatValue();
                float y = ((Double)segment.get(2)).floatValue();
                subPath.lineTo(x, y);
            }
            subPath.closePath();
            if ("P".equals(contour.get(1).toString())) {
                area.add(new Area(subPath));
                continue;
            }
            area.subtract(new Area(subPath));
        }
        GeneralPath finalPath = new GeneralPath();
        finalPath.append(area.getPathIterator(AffineTransform.getScaleInstance(1.0, -1.0)), false);
        newSign.setShape(finalPath);
        newSign.fixShape();
        String stdCode = "UG" + uid + "M" + mid + "N" + id;
        this.signs.put(stdCode, newSign);
        if (!this.codeMap.containsKey(stdCode)) {
            this.codeMap.put(stdCode, stdCode);
        }
    }

    public ShapeChar getCurrentShape() {
        return (ShapeChar)this.signs.get(this.codeList[this.pos]);
    }

    public boolean hasNext() {
        return this.pos + 1 < this.signs.size();
    }

    public boolean hasPrevious() {
        return this.pos > 0;
    }

    public void next() {
        if (this.hasNext()) {
            ++this.pos;
        }
    }

    public void previous() {
        if (this.hasPrevious()) {
            --this.pos;
        }
    }

    public String getCurrentCode() {
        return (String)this.codeMap.get(this.codeList[this.pos]);
    }

    public void afterLast() {
        this.pos = this.signs.size();
    }

    public void beforeFirst() {
        this.pos = -1;
    }
}

