/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.ui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jsesh.externalFonts.control.ExternalSignImporterPresenter;
import jsesh.externalFonts.model.ExternalSignImporterModel;
import jsesh.externalFonts.ui.ShapeDisplayer;
import jsesh.externalFonts.ui.UIEventListener;
import jsesh.resources.ResourcesManager;

public class ExternalSignImporterUI {
    private JPanel mainPanel = null;
    private JButton insertButton;
    private JButton closeButton;
    private JButton importButton;
    private JButton nextButton;
    private JButton previousButton;
    private JButton flipVerticallyButton;
    private JButton flipHorizontallyButton;
    private JButton fullCadratHeightButton;
    private JTextField codeField;
    private ShapeDisplayer importedSignDisplay;
    private ShapeDisplayer referenceSignDisplay;
    private UIEventListener uiEventListener;
    private JButton[] buttons;

    public ExternalSignImporterUI() {
        this.initComponents();
        this.mainPanel = this.build();
    }

    private void initComponents() {
        this.importButton = new JButton("Import file", ResourcesManager.getInstance().getIcon("Import file"));
        this.importButton.setToolTipText("Import glyph(s) from a truetype font, a bzr file, or an svg drawing");
        this.closeButton = new JButton("Close");
        this.insertButton = new JButton("Insert");
        this.insertButton.setToolTipText("Insert the currently displayed sign in the base with the current code");
        this.codeField = new JTextField(8);
        this.codeField.setToolTipText("Code to give to the new sign. The code should be a correct Gardiner-like code ");
        this.nextButton = new JButton(ResourcesManager.getInstance().getIcon("Next"));
        this.previousButton = new JButton(ResourcesManager.getInstance().getIcon("Previous"));
        this.flipHorizontallyButton = new JButton(ResourcesManager.getInstance().getIcon("Flip sign horizontally"));
        this.flipVerticallyButton = new JButton(ResourcesManager.getInstance().getIcon("Flip sign vertically"));
        this.importedSignDisplay = new ShapeDisplayer();
        ResizerListener resizeListener = new ResizerListener();
        this.importedSignDisplay.addMouseListener(resizeListener);
        this.importedSignDisplay.addMouseMotionListener(resizeListener);
        this.referenceSignDisplay = new ShapeDisplayer();
        this.fullCadratHeightButton = new JButton("Full cadrat Height");
        this.buttons = new JButton[]{this.insertButton, this.closeButton, this.importButton, this.nextButton, this.previousButton, this.flipHorizontallyButton, this.flipVerticallyButton, this.fullCadratHeightButton};
    }

    private JPanel build() {
        this.mainPanel = new JPanel();
        JSplitPane split = new JSplitPane(1, this.buildDisplayPanel(), this.buildFormPanel());
        this.mainPanel.add(split);
        return this.mainPanel;
    }

    private Component buildFormPanel() {
        FormLayout layout = new FormLayout("pref", "pref,pref,pref,pref,pref,pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(this.importButton);
        builder.nextLine();
        builder.addSeparator("New sign");
        builder.nextLine();
        builder.append("code :");
        builder.append(this.codeField);
        builder.nextLine();
        builder.append(this.insertButton);
        builder.nextRow();
        builder.append(this.flipHorizontallyButton);
        builder.append(this.flipVerticallyButton);
        builder.append(this.fullCadratHeightButton);
        builder.setDefaultDialogBorder();
        return builder.getPanel();
    }

    private JPanel buildDisplayPanel() {
        FormLayout layout = new FormLayout("pref,3dlu,pref", "pref,pref,pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        layout.setColumnGroups(new int[][]{{1, 3}});
        builder.append("A1 sign");
        builder.append("Current sign");
        builder.nextLine();
        builder.append(this.getReferenceSignDisplay());
        builder.append(this.getImportedSignDisplay());
        builder.nextLine();
        builder.nextColumn(2);
        builder.append(ButtonBarFactory.buildCenteredBar(this.getPreviousButton(), this.getNextButton()));
        return builder.getPanel();
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        ExternalSignImporterModel model = new ExternalSignImporterModel();
        ExternalSignImporterUI ui = new ExternalSignImporterUI();
        jf.getContentPane().add(ui.getPanel());
        ui.addEventListener(new ExternalSignImporterPresenter(model, ui));
        jf.pack();
        jf.setDefaultCloseOperation(3);
        jf.setVisible(true);
    }

    public void addEventListener(UIEventListener listener) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].addActionListener(listener);
        }
        CodeFieldListener codeFieldListener = new CodeFieldListener(listener);
        this.codeField.getDocument().addDocumentListener(codeFieldListener);
        this.uiEventListener = listener;
    }

    public JButton[] getButtons() {
        return this.buttons;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JTextField getCodeField() {
        return this.codeField;
    }

    public JButton getImportButton() {
        return this.importButton;
    }

    public JButton getInsertButton() {
        return this.insertButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getFullCadratHeightButton() {
        return this.fullCadratHeightButton;
    }

    public JButton getPreviousButton() {
        return this.previousButton;
    }

    public JButton getFlipHorizontallyButton() {
        return this.flipHorizontallyButton;
    }

    public JButton getFlipVerticallyButton() {
        return this.flipVerticallyButton;
    }

    public ShapeDisplayer getImportedSignDisplay() {
        return this.importedSignDisplay;
    }

    public ShapeDisplayer getReferenceSignDisplay() {
        return this.referenceSignDisplay;
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    private class ResizerListener
    extends MouseAdapter
    implements MouseMotionListener {
        private ResizerListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (ExternalSignImporterUI.this.importedSignDisplay.inResizeArea(e.getX(), e.getY())) {
                // empty if block
            }
        }

        public void mouseDragged(MouseEvent e) {
            double y = ExternalSignImporterUI.this.importedSignDisplay.convertToModelY(e.getY());
            ExternalSignImporterUI.this.uiEventListener.resizeVerticallyTo(y);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class CodeFieldListener
    implements DocumentListener {
        ActionListener listener;

        public CodeFieldListener(ActionListener listener) {
            this.listener = listener;
        }

        public void changedUpdate(DocumentEvent e) {
            this.listener.actionPerformed(new ActionEvent(ExternalSignImporterUI.this.codeField, 0, ""));
        }

        public void insertUpdate(DocumentEvent e) {
            this.listener.actionPerformed(new ActionEvent(ExternalSignImporterUI.this.codeField, 0, ""));
        }

        public void removeUpdate(DocumentEvent e) {
            this.listener.actionPerformed(new ActionEvent(ExternalSignImporterUI.this.codeField, 0, ""));
        }
    }
}

