/*
 * Decompiled with CFR 0.152.
 */
package jsesh.externalFonts.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import jsesh.bzr.simple.ShapeChar;
import jsesh.swingUtils.GraphicsUtils;

public class ShapeDisplayer
extends JComponent {
    private ShapeChar shape = null;
    private double displayHeight = 24.0;

    public ShapeDisplayer() {
        this.setPreferredSize(new Dimension(100, 100));
        this.setBackground(Color.WHITE);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        GraphicsUtils.antialias(g2d);
        double s = (double)this.getHeight() / this.displayHeight;
        g2d.scale(s, s);
        g2d.setColor(Color.BLACK);
        if (this.shape != null) {
            g2d.translate(0.0, this.displayHeight - this.shape.getBbox().getHeight());
            this.shape.draw(g2d, 0.0, 0.0, 1.0, 1.0, 0.0f);
            g2d.setStroke(new BasicStroke(0.25f));
            g2d.setColor(Color.RED);
            g2d.draw(this.shape.getBbox());
        }
    }

    public void setShape(ShapeChar shape) {
        this.shape = shape;
        this.repaint();
    }

    public void setDisplayHeight(double displayHeight) {
        this.displayHeight = displayHeight;
        this.repaint();
    }

    public ShapeChar getShape() {
        return this.shape;
    }

    public double getDisplayHeight() {
        return this.displayHeight;
    }

    public boolean inResizeArea(int x, int y) {
        return false;
    }

    public double convertToModelY(int y) {
        double scale = this.displayHeight / (double)this.getHeight();
        return this.displayHeight - (double)y * scale;
    }
}

