/*
 * Decompiled with CFR 0.152.
 */
package jsesh.fontEditor.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import jsesh.fontEditor.model.GlyphModel;
import jsesh.fontEditor.model.Point;

public class SimpleDrawView
extends JPanel
implements Observer {
    private double scale;
    private GlyphModel glyphModel;

    public SimpleDrawView(GlyphModel dessin) {
        this.glyphModel = dessin;
        this.scale = 1.0;
        dessin.addObserver(this);
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(320, 200));
        this.initialize();
    }

    private void initialize() {
        this.setBackground(new Color(226, 37, 37));
        this.setSize(424, 97);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.scale, this.scale);
        for (int i = 0; i < this.glyphModel.size(); ++i) {
            this.glyphModel.getForme(i).dessiner(g2);
        }
    }

    public void update(Observable o, Object arg) {
        this.repaint();
    }

    public GlyphModel getGlyphModel() {
        return this.glyphModel;
    }

    public void setGlyphModel(GlyphModel dessin) {
        this.glyphModel = dessin;
    }

    public Point screenToModel(int x, int y) {
        return new Point((double)x / this.scale, (double)y / this.scale);
    }

    public double screenDistanceToModel(int d) {
        return (double)d / this.scale;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
        this.repaint();
    }
}

