/*
 * Decompiled with CFR 0.152.
 */
package jsesh.fontEditor.gui;

import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;
import jsesh.fontEditor.control.Command;
import jsesh.fontEditor.control.CommandManager;
import jsesh.fontEditor.gui.SimpleDrawView;
import jsesh.fontEditor.model.GlyphModel;
import jsesh.fontEditor.model.Point;

public class ToolContext {
    private SimpleDrawView view;
    private CommandManager commandManager;

    public ToolContext(SimpleDrawView view) {
        this.view = view;
        this.commandManager = new CommandManager();
    }

    public SimpleDrawView getView() {
        return this.view;
    }

    public GlyphModel getDessin() {
        return this.view.getGlyphModel();
    }

    public Point getPointFromEvent(MouseEvent e) {
        return this.view.screenToModel(e.getX(), e.getY());
    }

    public void deconnecte(MouseInputListener control) {
        this.view.removeMouseListener(control);
        this.view.removeMouseMotionListener(control);
    }

    public void connecte(MouseInputListener control) {
        this.view.addMouseListener(control);
        this.view.addMouseMotionListener(control);
    }

    public void add(Command c) {
        this.commandManager.add(c);
    }

    public boolean canRedo() {
        return this.commandManager.canRedo();
    }

    public boolean canUndo() {
        return this.commandManager.canUndo();
    }

    public void redo() {
        this.commandManager.redo();
    }

    public void undo() {
        this.commandManager.undo();
    }
}

