/*
 * Decompiled with CFR 0.152.
 */
package jsesh.fontEditor.model;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import jsesh.fontEditor.model.Forme;
import jsesh.fontEditor.model.Point;

public class Cercle
extends Forme {
    private Point centre;
    private double r;

    public Cercle(Point centre, double rayon) {
        this.r = rayon;
        this.centre = centre;
    }

    public boolean contient(Point p, double tolerance) {
        return this.centre.distanceCarre(p) <= this.r * this.r;
    }

    public void dessiner(Graphics2D g) {
        g.setColor(this.getCouleur());
        Ellipse2D.Double s = new Ellipse2D.Double(this.centre.getX() - this.getRayon(), this.centre.getY() - this.getRayon(), 2.0 * this.getRayon(), 2.0 * this.getRayon());
        g.draw(s);
    }

    public Point getCentre() {
        return this.centre;
    }

    public double getRayon() {
        return this.r;
    }

    public void setRayon(double rayon) {
        this.r = rayon;
        this.setChanged();
        this.notifyObservers();
    }

    public void deplacer(double dx, double dy) {
        this.centre.deplacer(dx, dy);
        this.setChanged();
        this.notifyObservers();
    }
}

