/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.filechooser.FileFilter;
import jsesh.graphicExport.BaseGraphics2DFactory;
import jsesh.graphicExport.ExportData;
import jsesh.graphicExport.ExportOptionPanel;
import jsesh.graphicExport.SelectionExporter;
import jsesh.graphics.bitmaps.BitmapStreamGraphics;
import jsesh.graphics.generic.BaseGraphics2D;
import jsesh.swingUtils.RestrictedCharFormatter;
import jsesh.utils.FileUtils;

public class BitmapExporter {
    private String fileName;
    private File directory;
    private String basename;
    boolean multiFile;
    boolean transparency;
    int cadratHeight;
    int outputFormatIndex = 0;
    public static final String[] outputFormats = new String[]{"png", "jpg"};

    public BitmapExporter() {
        this.setSingleOutputFile(new File("unnamed.png"));
        this.multiFile = false;
        this.basename = "unnamed";
        this.transparency = true;
        this.cadratHeight = 32;
    }

    public int askUser(boolean onlySelection) {
        int result = 2;
        this.multiFile = !onlySelection;
        BitmapOptionPanel panel = new BitmapOptionPanel(null, "Export as bitmap file");
        result = panel.askAndSet();
        if (result == 2) {
            return result;
        }
        return result;
    }

    public void export(ExportData data) {
        try {
            float length = data.getDrawingSpecifications().getBaseLength();
            data.setScale((float)this.cadratHeight / length);
            if (this.multiFile) {
                this.exportAll(data);
            } else {
                this.exportSelection(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exportAll(ExportData data) throws IOException {
        SelectionExporter exporter = new SelectionExporter(data, new MultipleGraphicsFactory());
        if (this.getEffectiveTransparency()) {
            exporter.setBackground(new Color(0, 0, 0, 0));
        } else {
            exporter.setBackground(Color.WHITE);
        }
        exporter.setTransparency(this.getEffectiveTransparency());
        exporter.exportToPages();
    }

    public void exportSelection(ExportData data) throws IOException {
        SelectionExporter exporter = new SelectionExporter(data, new SingleGraphicsFactory());
        if (this.getEffectiveTransparency()) {
            exporter.setBackground(new Color(0, 0, 0, 0));
        } else {
            exporter.setBackground(Color.WHITE);
        }
        exporter.setTransparency(this.getEffectiveTransparency());
        exporter.exportSelection();
    }

    public File getSingleOutputFile() {
        return new File(this.directory, this.fileName);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setSingleOutputFile(File f) {
        this.directory = f.getParentFile();
        this.fileName = f.getName();
    }

    private boolean getEffectiveTransparency() {
        return this.outputFormatIndex == 0 && this.transparency;
    }

    private class BitmapOptionPanel
    extends ExportOptionPanel
    implements ActionListener {
        JFormattedTextField fileField;
        JButton browseButton;
        JFormattedTextField baseNameField;
        JComboBox outputFormatField;
        JFormattedTextField cadratHeightField;
        JCheckBox transparentField;
        public final int[] FORBIDDEN_CHARS;

        public BitmapOptionPanel(JComponent parent, String title) {
            super(parent, title);
            this.FORBIDDEN_CHARS = new int[]{58, 47, 46};
            this.fileField = new JFormattedTextField();
            this.fileField.setColumns(40);
            if (BitmapExporter.this.multiFile) {
                this.fileField.setValue(BitmapExporter.this.directory);
            } else {
                this.fileField.setValue(BitmapExporter.this.getSingleOutputFile());
            }
            this.browseButton = new JButton("Browse");
            this.browseButton.addActionListener(this);
            String fileFieldLabel = "Output file";
            if (BitmapExporter.this.multiFile) {
                this.baseNameField = new JFormattedTextField(new RestrictedCharFormatter(this.FORBIDDEN_CHARS));
                this.baseNameField.setValue(BitmapExporter.this.basename);
                this.baseNameField.setColumns(15);
                this.baseNameField.setToolTipText("Picture file name will start with this string.");
                fileFieldLabel = "Output directory";
            } else {
                this.baseNameField = null;
            }
            this.transparentField = new JCheckBox("Transparent Images", BitmapExporter.this.transparency);
            this.transparentField.setToolTipText("Should the output images have a transparent background ?");
            this.cadratHeightField = new JFormattedTextField(new Integer(BitmapExporter.this.cadratHeight));
            this.cadratHeightField.setColumns(3);
            this.cadratHeightField.setToolTipText("height of a typical line of hieroglyphs");
            this.outputFormatField = new JComboBox<String>(outputFormats);
            this.outputFormatField.setSelectedIndex(BitmapExporter.this.outputFormatIndex);
            this.outputFormatField.setToolTipText("Format of the saved images.\n Explicit extensions like .jpg or .png will have precedence over this field.");
            this.outputFormatField.addActionListener(this);
            FormLayout formLayout = new FormLayout("right:p,4dlu,left:max(40dlu;pref),4dlu,left:max(20dlu;pref),4dlu,left:max(20dlu;pref)", "");
            DefaultFormBuilder formBuilder = new DefaultFormBuilder(formLayout, this);
            formBuilder.setDefaultDialogBorder();
            formBuilder.append("Cadrat Height", (Component)this.cadratHeightField);
            formBuilder.append(this.transparentField);
            formBuilder.nextLine();
            formBuilder.appendSeparator("Output");
            formBuilder.nextLine();
            formBuilder.append(fileFieldLabel, (Component)this.fileField, 3);
            formBuilder.append(this.browseButton);
            formBuilder.nextLine();
            if (BitmapExporter.this.multiFile) {
                formBuilder.append("Base name for output files", (Component)this.baseNameField);
            }
            formBuilder.append("Output format", (Component)this.outputFormatField);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.browseButton) {
                JFileChooser chooser = new JFileChooser((File)this.fileField.getValue());
                if (!BitmapExporter.this.multiFile) {
                    chooser.addChoosableFileFilter(new FileFilter(){

                        public boolean accept(File f) {
                            boolean result = false;
                            result = f.isDirectory();
                            for (int i = 0; !result && i < outputFormats.length; ++i) {
                                result = result || f.getName().toLowerCase().endsWith("." + outputFormats[i]);
                            }
                            return result;
                        }

                        public String getDescription() {
                            String s = outputFormats[0];
                            for (int i = 1; i < outputFormats.length; ++i) {
                                s = s + ", " + outputFormats[i];
                            }
                            return s;
                        }
                    });
                    chooser.setSelectedFile((File)this.fileField.getValue());
                    int userResult = chooser.showSaveDialog(null);
                    if (userResult == 0) {
                        this.fileField.setValue(chooser.getSelectedFile());
                        this.fixExtension();
                    }
                } else {
                    chooser.setFileSelectionMode(1);
                    int userResult = chooser.showDialog(null, "Choose output directory");
                    if (userResult == 0) {
                        this.fileField.setValue(chooser.getSelectedFile());
                    }
                }
            } else if (e.getSource() == this.outputFormatField && !BitmapExporter.this.multiFile) {
                File f = (File)this.fileField.getValue();
                f = FileUtils.buildFileWithExtension(f, (String)this.outputFormatField.getSelectedItem());
                this.fileField.setValue(f);
            }
        }

        private void fixExtension() {
            if (!BitmapExporter.this.multiFile) {
                List<String> l;
                boolean mustCorrectExtension = true;
                File file = (File)this.fileField.getValue();
                String ext = FileUtils.getExtension(file);
                if (ext != null && (l = Arrays.asList(outputFormats)).contains(ext)) {
                    mustCorrectExtension = false;
                    this.outputFormatField.setSelectedItem(ext);
                }
                if (mustCorrectExtension) {
                    String correctFormat = (String)this.outputFormatField.getSelectedItem();
                    file = FileUtils.buildFileWithExtension(file, correctFormat);
                    this.fileField.setValue(file);
                }
            }
        }

        public void setOptions() {
            if (BitmapExporter.this.multiFile) {
                BitmapExporter.this.directory = (File)this.fileField.getValue();
                BitmapExporter.this.basename = (String)this.baseNameField.getValue();
            } else {
                BitmapExporter.this.setSingleOutputFile((File)this.fileField.getValue());
            }
            BitmapExporter.this.transparency = this.transparentField.isSelected();
            BitmapExporter.this.cadratHeight = ((Number)this.cadratHeightField.getValue()).intValue();
            BitmapExporter.this.outputFormatIndex = this.outputFormatField.getSelectedIndex();
        }
    }

    private class MultipleGraphicsFactory
    implements BaseGraphics2DFactory {
        private int n = 1;
        private Dimension scaledDimensions;

        private MultipleGraphicsFactory() {
        }

        public BaseGraphics2D buildGraphics() throws IOException {
            String num = "" + this.n;
            ++this.n;
            if (num.length() == 1) {
                num = "00" + num;
            } else if (num.length() == 2) {
                num = "0" + num;
            }
            File f = new File(BitmapExporter.this.directory, BitmapExporter.this.basename + num + "." + outputFormats[BitmapExporter.this.outputFormatIndex]);
            FileOutputStream out = new FileOutputStream(f);
            BitmapStreamGraphics g = new BitmapStreamGraphics(out, this.scaledDimensions, outputFormats[BitmapExporter.this.outputFormatIndex], BitmapExporter.this.getEffectiveTransparency());
            return g;
        }

        public void setDimension(Dimension scaledDimensions) {
            this.scaledDimensions = scaledDimensions;
        }
    }

    private class SingleGraphicsFactory
    implements BaseGraphics2DFactory {
        private Dimension scaledDimensions;

        private SingleGraphicsFactory() {
        }

        public void setDimension(Dimension deviceDimensions) {
            this.scaledDimensions = deviceDimensions;
        }

        public BaseGraphics2D buildGraphics() throws IOException {
            FileOutputStream out = new FileOutputStream(BitmapExporter.this.getSingleOutputFile());
            BitmapStreamGraphics g = new BitmapStreamGraphics(out, this.scaledDimensions, outputFormats[BitmapExporter.this.outputFormatIndex], BitmapExporter.this.getEffectiveTransparency());
            return g;
        }
    }
}

