/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import jsesh.graphics.bitmaps.BitmapStreamGraphics;
import jsesh.graphics.bitmaps.MultiFileGraphics;
import jsesh.graphics.generic.BaseGraphics2D;

class BitmapGraphicsFactory
implements MultiFileGraphics.Graphics2DFactory {
    String format;
    Color background;

    public BitmapGraphicsFactory(String format, Color background) {
        this.format = format;
        this.background = background;
    }

    public BaseGraphics2D createGraphics(File f, int pageNumber, Dimension dimension) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(f);
        BitmapStreamGraphics result = new BitmapStreamGraphics(out, dimension, this.format, this.background.getTransparency() == 3);
        if (this.background != null) {
            ((BaseGraphics2D)result).setBackground(this.background);
        }
        ((BaseGraphics2D)result).clearRect(0, 0, dimension.width, dimension.height);
        return result;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

