/*
 * Decompiled with CFR 0.152.
 */
package jsesh.graphicExport;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Graphic;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import jsesh.graphicExport.ExportOptionPanel;
import jsesh.mdc.model.AlphabeticText;
import jsesh.mdc.model.HRule;
import jsesh.mdc.model.LineBreak;
import jsesh.mdc.model.ModelElementDeepAdapter;
import jsesh.mdc.model.PageBreak;
import jsesh.mdc.model.TabStop;
import jsesh.mdc.model.TopItem;
import jsesh.mdc.model.TopItemList;
import jsesh.mdcDisplayer.draw.ViewDrawer;
import jsesh.mdcDisplayer.layout.MDCEditorKit;
import jsesh.mdcDisplayer.layout.SimpleViewBuilder;
import jsesh.mdcDisplayer.mdcView.MDCView;
import jsesh.mdcDisplayer.preferences.DrawingSpecifications;
import jsesh.utils.FileUtils;
import jsesh.utils.TranslitterationUtilities;

public class IPDFExporter {
    private boolean respectPages;
    private File file;
    private String title;
    private String author;
    private String subject;
    private String keywords;
    private boolean showPageNumbers;
    private DrawingSpecifications drawingSpecifications = MDCEditorKit.getBasicMDCEditorKit().getDrawingSpecifications();
    private Color backgroundColor = Color.WHITE;
    TreeMap pageFormats;
    String pageSize;
    private int lineHeight;
    static /* synthetic */ Class class$com$lowagie$text$Rectangle;

    public IPDFExporter() {
        this.fillPageSizes();
        this.setDefaults();
    }

    public void setDefaults() {
        this.file = new File("default.pdf");
        this.title = "";
        this.keywords = "";
        this.subject = "";
        this.author = System.getProperty("user.name");
        this.respectPages = true;
        this.pageSize = "A4";
        this.lineHeight = 14;
        this.showPageNumbers = true;
    }

    private void fillPageSizes() {
        this.pageFormats = new TreeMap();
        Field[] fields = PageSize.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().equals(class$com$lowagie$text$Rectangle == null ? IPDFExporter.class$("com.lowagie.text.Rectangle") : class$com$lowagie$text$Rectangle)) continue;
            try {
                this.pageFormats.put(fields[i].getName(), fields[i].get(null));
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public ExportOptionPanel getOptionPanel(Component parent, String title) {
        return new OptionPanel(parent, title);
    }

    public void exportModel(TopItemList model) throws IOException {
        try {
            IPDFExporterAux visitor = new IPDFExporterAux();
            model.accept(visitor);
            visitor.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }

    public boolean isRespectPages() {
        return this.respectPages;
    }

    public String getTitle() {
        return this.title;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setRespectPages(boolean b) {
        this.respectPages = b;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(int i) {
        this.lineHeight = i;
    }

    public boolean isShowPageNumbers() {
        return this.showPageNumbers;
    }

    public void setShowPageNumbers(boolean includePageNumber) {
        this.showPageNumbers = includePageNumber;
    }

    class OptionPanel
    extends ExportOptionPanel
    implements ActionListener {
        JFormattedTextField fileField;
        JTextField titleField;
        JTextField authorField;
        JTextField subjectField;
        JTextField keywordsField;
        JFormattedTextField lineHeightField;
        JCheckBox showPageNumberBox;
        JComboBox formatField;
        JButton browse;

        private OptionPanel(Component parent, String paneltitle) {
            super(parent, paneltitle);
            this.titleField = new JTextField(IPDFExporter.this.title, 40);
            this.titleField.setToolTipText("Title of the pdf document");
            this.authorField = new JTextField(40);
            this.authorField.setText(IPDFExporter.this.author);
            this.subjectField = new JTextField(40);
            this.keywordsField = new JTextField(40);
            this.fileField = new JFormattedTextField();
            this.fileField.setValue(IPDFExporter.this.file);
            this.fileField.setColumns(40);
            this.fileField.setEditable(false);
            this.browse = new JButton("Browse");
            this.browse.addActionListener(this);
            this.lineHeightField = new JFormattedTextField();
            this.lineHeightField.setValue(new Integer(IPDFExporter.this.lineHeight));
            this.lineHeightField.setToolTipText("height of a typical line of hieroglyphs");
            this.formatField = new JComboBox<Object>(IPDFExporter.this.pageFormats.keySet().toArray());
            this.formatField.setSelectedItem(IPDFExporter.this.pageSize);
            this.showPageNumberBox = new JCheckBox("Show page numbers", IPDFExporter.this.isShowPageNumbers());
            FormLayout layout = new FormLayout("right:p,4dlu,left:max(40dlu;pref),4dlu,left:max(20dlu;pref)", "");
            DefaultFormBuilder formBuilder = new DefaultFormBuilder(layout);
            formBuilder.setDefaultDialogBorder();
            formBuilder.append("Document Title", (Component)this.titleField, 3);
            formBuilder.nextLine();
            formBuilder.append("Author", (Component)this.authorField, 3);
            formBuilder.append("Subject", (Component)this.subjectField, 3);
            formBuilder.append("Keywords", (Component)this.keywordsField, 3);
            formBuilder.append("Line Height", (Component)this.lineHeightField);
            this.lineHeightField.setToolTipText("height of standard hieroglyphic cadrats, in points");
            formBuilder.nextLine();
            formBuilder.append("Page Format", (Component)this.formatField, 1);
            formBuilder.nextLine();
            formBuilder.append(this.showPageNumberBox);
            formBuilder.nextLine();
            formBuilder.appendSeparator("Output");
            formBuilder.nextLine();
            formBuilder.append("File", (Component)this.fileField, (Component)this.browse);
            this.setLayout(new BorderLayout());
            this.add((Component)formBuilder.getPanel(), "Center");
        }

        public void setOptions() {
            IPDFExporter.this.file = new File(this.fileField.getText());
            this.title = this.titleField.getText();
            IPDFExporter.this.author = this.authorField.getText();
            IPDFExporter.this.subject = this.subjectField.getText();
            IPDFExporter.this.keywords = this.keywordsField.getText();
            IPDFExporter.this.lineHeight = Integer.parseInt(this.lineHeightField.getText());
            IPDFExporter.this.title = this.titleField.getText();
            IPDFExporter.this.pageSize = (String)this.formatField.getSelectedItem();
            IPDFExporter.this.respectPages = true;
            IPDFExporter.this.showPageNumbers = this.showPageNumberBox.isSelected();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.browse) {
                JFileChooser chooser = new JFileChooser();
                chooser.setSelectedFile(IPDFExporter.this.file);
                chooser.setApproveButtonText("Choose file");
                chooser.setFileFilter(new FileFilter(){

                    public String getDescription() {
                        return "pdf files";
                    }

                    public boolean accept(File f) {
                        return f.getName().endsWith(".pdf") || f.getName().endsWith(".PDF") || f.isDirectory();
                    }
                });
                int res = chooser.showSaveDialog(this);
                if (res == 0) {
                    File selected = chooser.getSelectedFile();
                    selected = FileUtils.buildFileWithExtension(selected, "pdf");
                    this.fileField.setValue(selected);
                }
            }
        }
    }

    private class IPDFExporterAux
    extends ModelElementDeepAdapter {
        Document pdfDocument;
        PdfWriter writer;
        Paragraph currentParagraph;
        Font translitFont;
        Font italicFont;
        Font romanFont;
        Font boldFont;
        DefaultFontMapper fontMapper;
        TreeMap imageCache = new TreeMap();
        DrawingSpecifications actualDrawingSpecifications;
        SimpleViewBuilder builder;

        public IPDFExporterAux() throws IOException, DocumentException {
            this.prepareFonts();
            this.builder = new SimpleViewBuilder();
            this.actualDrawingSpecifications = IPDFExporter.this.drawingSpecifications.copy();
            this.actualDrawingSpecifications.setLeftMargin(0.1f);
            this.pdfDocument = new Document();
            this.pdfDocument.setPageSize((Rectangle)IPDFExporter.this.pageFormats.get(IPDFExporter.this.pageSize));
            this.writer = PdfWriter.getInstance(this.pdfDocument, new FileOutputStream(IPDFExporter.this.file));
            if (IPDFExporter.this.showPageNumbers) {
                this.writer.setPageEvent(new PDFPageNumberHandler());
            }
            this.pdfDocument.addTitle(IPDFExporter.this.title);
            this.pdfDocument.addAuthor(IPDFExporter.this.author);
            this.pdfDocument.addSubject(IPDFExporter.this.subject);
            this.pdfDocument.addKeywords(IPDFExporter.this.keywords);
            this.pdfDocument.addCreator("JSesh");
            this.currentParagraph = null;
            this.pdfDocument.open();
        }

        private void prepareFonts() throws DocumentException, IOException {
            BaseFont bf = BaseFont.createFont("/jseshResources/fonts/MDCTranslitLC.ttf", "Identity-H", true);
            this.translitFont = new Font(bf, 12.0f);
            this.romanFont = FontFactory.getFont("Times", 12.0f, 0);
            this.italicFont = FontFactory.getFont("Times", 12.0f, 2);
            this.boldFont = FontFactory.getFont("Times", 12.0f, 1);
            this.fontMapper = new DefaultFontMapper();
            this.fontMapper.putName("MDCTranslitLC", new DefaultFontMapper.BaseFontParameters("/jseshResources/fonts/MDCTranslitLC.ttf"));
        }

        public void close() {
            this.flushParagraph();
            this.pdfDocument.close();
        }

        public void visitTopItemList(TopItemList t) {
            try {
                this.startPage();
                for (int i = 0; i < t.getNumberOfChildren(); ++i) {
                    t.getChildAt(i).accept(this);
                }
                this.closePage(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void visitHRule(HRule h) {
            Graphic pdfGraphics = new Graphic();
            float x1 = (float)h.getStartPos() * this.actualDrawingSpecifications.getBaseLength() / 200.0f;
            float x2 = (float)h.getEndPos() * this.actualDrawingSpecifications.getBaseLength() / 200.0f;
            float y = this.writer.getVerticalPosition(false);
            if (h.getType() == 'l') {
                pdfGraphics.setLineWidth(this.actualDrawingSpecifications.getFineLineWidth());
            } else {
                pdfGraphics.setLineWidth(this.actualDrawingSpecifications.getWideLineWidth());
            }
            pdfGraphics.moveTo(x1, y);
            pdfGraphics.lineTo(x2, y);
            pdfGraphics.stroke();
            try {
                this.pdfDocument.add(pdfGraphics);
            }
            catch (DocumentException exception) {
                exception.printStackTrace();
            }
        }

        public void visitAlphabeticText(AlphabeticText t) {
            Font f = null;
            String text = t.getText();
            switch (t.getScriptCode()) {
                case 'l': {
                    f = this.romanFont;
                    break;
                }
                case 'b': {
                    f = this.boldFont;
                    break;
                }
                case 'i': {
                    f = this.italicFont;
                    break;
                }
                case 't': {
                    f = this.translitFont;
                    text = TranslitterationUtilities.toLowerCase(text);
                    break;
                }
                default: {
                    return;
                }
            }
            this.write(text, f);
        }

        public void visitPageBreak(PageBreak b) {
            this.flushParagraph();
            if (IPDFExporter.this.respectPages) {
                try {
                    this.pdfDocument.newPage();
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
            }
        }

        public void visitLineBreak(LineBreak b) {
            if (this.currentParagraph == null) {
                this.currentParagraph = new Paragraph();
                this.currentParagraph.add(new Chunk(" "));
            }
            this.flushParagraph();
        }

        public void visitTopItem(TopItem t) {
            this.drawElement(t);
        }

        public void visitTabStop(TabStop t) {
            if (this.currentParagraph != null) {
                System.out.println(this.currentParagraph.leading());
                this.currentParagraph.setSpacingAfter(-this.currentParagraph.leading());
                this.flushParagraph();
            }
            this.currentParagraph = new Paragraph();
            this.currentParagraph.setIndentationLeft((float)t.getStopPos() * this.actualDrawingSpecifications.getBaseLength() / 200.0f);
        }

        private void write(String s, Font font) {
            this.addChunck(new Chunk(s, font));
        }

        public void flushParagraph() {
            if (this.currentParagraph != null) {
                try {
                    this.pdfDocument.add(this.currentParagraph);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
            }
            this.currentParagraph = null;
        }

        private void drawElement(TopItem elt) {
            TemplateInfo templateInfo = (TemplateInfo)this.imageCache.get(elt);
            if (templateInfo == null) {
                TopItemList smallModel = new TopItemList();
                smallModel.addTopItem((TopItem)elt.deepCopy());
                double scale = (double)IPDFExporter.this.lineHeight / (double)this.actualDrawingSpecifications.getMaxCadratHeight();
                MDCView view = this.builder.buildView(smallModel, this.actualDrawingSpecifications);
                if (view.getWidth() == 0.0f || view.getHeight() == 0.0f) {
                    return;
                }
                ViewDrawer drawer = new ViewDrawer();
                PdfContentByte cb = this.writer.getDirectContent();
                float width = (float)((double)view.getWidth() * scale);
                float height = (float)((double)view.getHeight() * scale);
                templateInfo = new TemplateInfo();
                templateInfo.template = cb.createTemplate(width, height);
                Graphics2D g = templateInfo.template.createGraphics(width, height, this.fontMapper);
                g.setColor(Color.BLACK);
                g.setBackground(IPDFExporter.this.backgroundColor);
                g.scale(scale, scale);
                drawer.draw(g, view, this.actualDrawingSpecifications);
                g.dispose();
                double deltay = 0.0;
                if (view.getFirstSubView() != null) {
                    deltay = view.getFirstSubView().getDeltaBaseY();
                }
                templateInfo.dx = 0.0;
                templateInfo.dy = -6.0 + deltay;
                templateInfo.template.setLeading((float)((double)view.getHeight() * scale));
                this.imageCache.put(elt, templateInfo);
            }
            try {
                Image img = Image.getInstance(templateInfo.template);
                this.addChunck(new Chunk(img, (float)templateInfo.dx, (float)templateInfo.dy, true));
                this.addChunck(new Chunk(' ').setHorizontalScaling(0.25f));
                if (templateInfo.template.getLeading() > this.currentParagraph.leading()) {
                    this.currentParagraph.setLeading(templateInfo.template.getLeading());
                }
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
        }

        private void addChunck(Element chunk) {
            if (this.currentParagraph == null) {
                this.currentParagraph = new Paragraph();
            }
            this.currentParagraph.add(chunk);
        }

        private void startPage() throws IOException {
        }

        private void closePage(boolean hasNext) {
        }

        public class PDFPageNumberHandler
        extends PdfPageEventHelper {
            public void onStartPage(PdfWriter arg0, Document arg1) {
            }

            public void onEndPage(PdfWriter writer, Document document) {
                PdfContentByte cb = writer.getDirectContent();
                cb.saveState();
                String text = "" + writer.getPageNumber();
                float textSize = IPDFExporterAux.this.romanFont.getBaseFont().getWidthPoint(text, 12.0f);
                float textBase = document.bottom() - 20.0f;
                cb.beginText();
                cb.setFontAndSize(IPDFExporterAux.this.romanFont.getBaseFont(), 12.0f);
                if ((writer.getPageNumber() & 1) == 1) {
                    cb.setTextMatrix(document.left(), textBase);
                    cb.showText(text);
                    cb.endText();
                } else {
                    float adjust = IPDFExporterAux.this.romanFont.getBaseFont().getWidthPoint("0", 12.0f);
                    cb.setTextMatrix(document.right() - textSize - adjust, textBase);
                    cb.showText(text);
                    cb.endText();
                }
                cb.restoreState();
            }
        }
    }

    private static class TemplateInfo {
        PdfTemplate template;
        double dx;
        double dy;

        private TemplateInfo() {
        }
    }
}

