/*
 * Decompiled with CFR 0.152.
 */
package jsesh.hieroglyphs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import jsesh.bzr.simple.ShapeChar;
import jsesh.externalFonts.model.SVGSignSource;
import jsesh.hieroglyphs.HieroglyphicFontManager;

public class DirectoryHieroglyphicFontManager
implements HieroglyphicFontManager {
    File directory;
    HashMap codeMap;
    HashMap signsMap;
    long lastRefreshed;
    boolean hasNewSigns;

    public DirectoryHieroglyphicFontManager(File directory) {
        this.directory = directory;
        this.codeMap = new HashMap();
        this.signsMap = new HashMap();
        this.hasNewSigns = true;
        this.lastRefreshed = System.currentTimeMillis();
        this.refresh();
    }

    public void refresh() {
        this.codeMap.clear();
        this.signsMap.clear();
        File[] contents = this.directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".svg");
            }
        });
        if (contents == null) {
            return;
        }
        for (int i = 0; i < contents.length; ++i) {
            String code = SVGSignSource.getCodeForFileName(contents[i].getName());
            if (code == null) continue;
            this.codeMap.put(code, contents[i]);
        }
        this.hasNewSigns = true;
        this.lastRefreshed = this.directory.lastModified();
    }

    public ShapeChar get(String code) {
        ShapeChar result = null;
        this.refreshIfNeeded();
        if (this.signsMap.containsKey(code)) {
            result = (ShapeChar)this.signsMap.get(code);
        } else if (this.codeMap.containsKey(code)) {
            SVGSignSource src = new SVGSignSource((File)this.codeMap.get(code));
            result = src.getCurrentShape();
            this.signsMap.put(code, result);
        }
        return result;
    }

    public Set getCodes() {
        this.refreshIfNeeded();
        this.hasNewSigns = false;
        return this.codeMap.keySet();
    }

    private void refreshIfNeeded() {
        if (this.directory.lastModified() > this.lastRefreshed) {
            this.refresh();
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public void insertNewSign(String code, ShapeChar shapeChar) {
        File f = new File(this.directory, code + ".svg");
        try {
            FileOutputStream out = new FileOutputStream(f);
            shapeChar.exportToSVG(out, "US-ASCII");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hasNewSigns = true;
    }

    public boolean hasNewSigns() {
        if (this.directory.lastModified() > this.lastRefreshed) {
            this.hasNewSigns = true;
        }
        return this.hasNewSigns;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
        this.refresh();
    }
}

