/*
 * Decompiled with CFR 0.152.
 */
package jsesh.hieroglyphs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import jsesh.bzr.simple.ShapeChar;
import jsesh.externalFonts.model.SVGSignSource;
import jsesh.hieroglyphs.HieroglyphicFontManager;

public class ResourcesHieroglyphicFontManager
implements HieroglyphicFontManager {
    private String resourcePath;
    public static final String LIST_FILE = "list.txt";
    HashMap signs;

    public ResourcesHieroglyphicFontManager(String resourcePath) {
        this.resourcePath = resourcePath;
        this.signs = new HashMap();
        try {
            InputStream ins = this.getClass().getResourceAsStream(resourcePath + "/" + LIST_FILE);
            if (ins != null) {
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader(ins, "US-ASCII"));
                while ((line = r.readLine()) != null) {
                    String[] fields = line.split("\t");
                    this.signs.put(fields[0], fields[1]);
                }
                r.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initDirectory(File src) throws IOException {
        System.err.println("pos " + src.getCanonicalPath());
        FileOutputStream os = new FileOutputStream(new File(src, LIST_FILE));
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, "US-ASCII");
        ResourcesHieroglyphicFontManager.initDirectoryAux(src, out);
        out.close();
    }

    private static void initDirectoryAux(File src, Writer out) throws IOException {
        File[] svgs = src.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().toLowerCase().endsWith(".svg");
            }
        });
        for (int i = 0; i < svgs.length; ++i) {
            if (svgs[i].isDirectory()) {
                ResourcesHieroglyphicFontManager.initDirectoryAux(svgs[i], out);
                continue;
            }
            System.out.println(svgs[i].getName());
            String code = SVGSignSource.getCodeForFileName(svgs[i].getName());
            if (code == null) continue;
            out.write(code);
            out.write(9);
            out.write(svgs[i].getName());
            out.write(10);
        }
    }

    public ShapeChar get(String code) {
        ShapeChar result = null;
        if (this.signs.containsKey(code)) {
            Object data = this.signs.get(code);
            if (data instanceof String) {
                String path = this.resourcePath + "/" + data;
                SVGSignSource src = new SVGSignSource(this.getClass().getResource(path));
                if (src.hasNext()) {
                    src.next();
                    result = src.getCurrentShape();
                    this.signs.put(code, result);
                }
            } else {
                result = (ShapeChar)data;
            }
        }
        return result;
    }

    public Set getCodes() {
        return this.signs.keySet();
    }

    public boolean hasNewSigns() {
        return false;
    }

    public static void main(String[] args) throws IOException {
        System.err.println(new File(args[0]));
        ResourcesHieroglyphicFontManager.initDirectory(new File(args[0]));
    }
}

