/*
 * Decompiled with CFR 0.152.
 */
package jsesh.mdc;

import java.io.Reader;
import java_cup.runtime.Symbol;
import jsesh.mdc.interfaces.MDCBuilder;
import jsesh.mdc.lex.MDCLex;
import jsesh.mdc.parser.MDCParse;
import jsesh.mdc.utils.MDCSyntaxError;

public class MDCParserFacade {
    private MDCParse parser = new MDCParse();
    private boolean debug;
    private MDCBuilder builder;
    private boolean philologyAsSigns;

    private MDCParserFacade() {
        this.setDebug(false);
        this.setPhilologyAsSigns(true);
    }

    public MDCParserFacade(MDCBuilder builder) {
        this();
        this.setBuilder(builder);
    }

    public MDCBuilder getBuilder() {
        return this.parser.getBuilder();
    }

    public void setBuilder(MDCBuilder v) {
        this.parser.setBuilder(v);
    }

    public Object parse(Reader in) throws MDCSyntaxError {
        Symbol parse_tree = null;
        MDCLex lex = new MDCLex(in);
        lex.setPhilologyAsSigns(this.philologyAsSigns);
        lex.setDebug(this.debug);
        this.parser.setScanner(lex);
        this.parser.setErrorManager(lex);
        try {
            parse_tree = this.isDebug() ? this.parser.debug_parse() : this.parser.parse();
            return parse_tree.value;
        }
        catch (MDCSyntaxError e) {
            throw e;
        }
        catch (Exception e) {
            MDCSyntaxError err = new MDCSyntaxError("Generic Error", 0, 0, e.getMessage());
            err.setStackTrace(e.getStackTrace());
            throw err;
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean v) {
        this.debug = v;
    }

    public boolean isPhilologyAsSigns() {
        return this.philologyAsSigns;
    }

    public void setPhilologyAsSigns(boolean v) {
        this.philologyAsSigns = v;
    }
}

